package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVpnGatewaysResponse(
    vpnGateways: Option[Iterable[zio.aws.ec2.model.VpnGateway]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysResponse = {
    import DescribeVpnGatewaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysResponse
      .builder()
      .optionallyWith(
        vpnGateways.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpnGateways)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVpnGatewaysResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVpnGatewaysResponse.wrap(buildAwsValue())
}
object DescribeVpnGatewaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpnGatewaysResponse =
      zio.aws.ec2.model.DescribeVpnGatewaysResponse(
        vpnGateways.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vpnGateways: Option[List[zio.aws.ec2.model.VpnGateway.ReadOnly]]
    def getVpnGateways
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.VpnGateway.ReadOnly]] =
      AwsError.unwrapOptionField("vpnGateways", vpnGateways)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysResponse
  ) extends zio.aws.ec2.model.DescribeVpnGatewaysResponse.ReadOnly {
    override val vpnGateways
        : Option[List[zio.aws.ec2.model.VpnGateway.ReadOnly]] = scala
      .Option(impl.vpnGateways())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VpnGateway.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysResponse
  ): zio.aws.ec2.model.DescribeVpnGatewaysResponse.ReadOnly = new Wrapper(impl)
}
