package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, ConnectionNotificationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVpcEndpointConnectionNotificationsRequest(
    connectionNotificationId: Option[ConnectionNotificationId] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest = {
    import DescribeVpcEndpointConnectionNotificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest
      .builder()
      .optionallyWith(
        connectionNotificationId.map(value =>
          ConnectionNotificationId.unwrap(value): java.lang.String
        )
      )(_.connectionNotificationId)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest
      .wrap(buildAwsValue())
}
object DescribeVpcEndpointConnectionNotificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest =
      zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest(
        connectionNotificationId.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def connectionNotificationId: Option[ConnectionNotificationId]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def getConnectionNotificationId
        : ZIO[Any, AwsError, ConnectionNotificationId] = AwsError
      .unwrapOptionField("connectionNotificationId", connectionNotificationId)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest
  ) extends zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest.ReadOnly {
    override val connectionNotificationId: Option[ConnectionNotificationId] =
      scala
        .Option(impl.connectionNotificationId())
        .map(value =>
          zio.aws.ec2.model.primitives.ConnectionNotificationId(value)
        )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest
  ): zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest.ReadOnly =
    new Wrapper(impl)
}
