package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVolumesResponse(
    volumes: Option[Iterable[zio.aws.ec2.model.Volume]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse = {
    import DescribeVolumesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse
      .builder()
      .optionallyWith(
        volumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumes)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVolumesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVolumesResponse.wrap(buildAwsValue())
}
object DescribeVolumesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVolumesResponse =
      zio.aws.ec2.model.DescribeVolumesResponse(
        volumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def volumes: Option[List[zio.aws.ec2.model.Volume.ReadOnly]]
    def nextToken: Option[String]
    def getVolumes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Volume.ReadOnly]] =
      AwsError.unwrapOptionField("volumes", volumes)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse
  ) extends zio.aws.ec2.model.DescribeVolumesResponse.ReadOnly {
    override val volumes: Option[List[zio.aws.ec2.model.Volume.ReadOnly]] =
      scala
        .Option(impl.volumes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Volume.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse
  ): zio.aws.ec2.model.DescribeVolumesResponse.ReadOnly = new Wrapper(impl)
}
