package zio.aws.ec2.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DateTime,
  SpotFleetRequestId,
  DescribeSpotFleetRequestHistoryMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeSpotFleetRequestHistoryRequest(
    eventType: Option[zio.aws.ec2.model.EventType] = None,
    maxResults: Option[DescribeSpotFleetRequestHistoryMaxResults] = None,
    nextToken: Option[String] = None,
    spotFleetRequestId: SpotFleetRequestId,
    startTime: DateTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest = {
    import DescribeSpotFleetRequestHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest
      .builder()
      .optionallyWith(eventType.map(value => value.unwrap))(_.eventType)
      .optionallyWith(
        maxResults.map(value =>
          DescribeSpotFleetRequestHistoryMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .spotFleetRequestId(
        SpotFleetRequestId.unwrap(spotFleetRequestId): java.lang.String
      )
      .startTime(DateTime.unwrap(startTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeSpotFleetRequestHistoryRequest.ReadOnly =
    zio.aws.ec2.model.DescribeSpotFleetRequestHistoryRequest
      .wrap(buildAwsValue())
}
object DescribeSpotFleetRequestHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSpotFleetRequestHistoryRequest =
      zio.aws.ec2.model.DescribeSpotFleetRequestHistoryRequest(
        eventType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        spotFleetRequestId,
        startTime
      )
    def eventType: Option[zio.aws.ec2.model.EventType]
    def maxResults: Option[DescribeSpotFleetRequestHistoryMaxResults]
    def nextToken: Option[String]
    def spotFleetRequestId: SpotFleetRequestId
    def startTime: DateTime
    def getEventType: ZIO[Any, AwsError, zio.aws.ec2.model.EventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeSpotFleetRequestHistoryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSpotFleetRequestId: ZIO[Any, Nothing, SpotFleetRequestId] =
      ZIO.succeed(spotFleetRequestId)
    def getStartTime: ZIO[Any, Nothing, DateTime] = ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest
  ) extends zio.aws.ec2.model.DescribeSpotFleetRequestHistoryRequest.ReadOnly {
    override val eventType: Option[zio.aws.ec2.model.EventType] = scala
      .Option(impl.eventType())
      .map(value => zio.aws.ec2.model.EventType.wrap(value))
    override val maxResults: Option[DescribeSpotFleetRequestHistoryMaxResults] =
      scala
        .Option(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeSpotFleetRequestHistoryMaxResults(value)
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val spotFleetRequestId: SpotFleetRequestId =
      zio.aws.ec2.model.primitives.SpotFleetRequestId(impl.spotFleetRequestId())
    override val startTime: DateTime =
      zio.aws.ec2.model.primitives.DateTime(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest
  ): zio.aws.ec2.model.DescribeSpotFleetRequestHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
