package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{ReservedInstancesOfferingId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReservedInstancesOfferingsRequest(
    availabilityZone: Option[String] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    includeMarketplace: Option[Boolean] = None,
    instanceType: Option[zio.aws.ec2.model.InstanceType] = None,
    maxDuration: Option[Long] = None,
    maxInstanceCount: Option[Integer] = None,
    minDuration: Option[Long] = None,
    offeringClass: Option[zio.aws.ec2.model.OfferingClassType] = None,
    productDescription: Option[zio.aws.ec2.model.RIProductDescription] = None,
    reservedInstancesOfferingIds: Option[
      Iterable[ReservedInstancesOfferingId]
    ] = None,
    instanceTenancy: Option[zio.aws.ec2.model.Tenancy] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None,
    offeringType: Option[zio.aws.ec2.model.OfferingTypeValues] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest = {
    import DescribeReservedInstancesOfferingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        includeMarketplace.map(value => value: java.lang.Boolean)
      )(_.includeMarketplace)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(maxDuration.map(value => value: java.lang.Long))(
        _.maxDuration
      )
      .optionallyWith(
        maxInstanceCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxInstanceCount)
      .optionallyWith(minDuration.map(value => value: java.lang.Long))(
        _.minDuration
      )
      .optionallyWith(offeringClass.map(value => value.unwrap))(_.offeringClass)
      .optionallyWith(productDescription.map(value => value.unwrap))(
        _.productDescription
      )
      .optionallyWith(
        reservedInstancesOfferingIds.map(value =>
          value.map { item =>
            ReservedInstancesOfferingId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.reservedInstancesOfferingIds)
      .optionallyWith(instanceTenancy.map(value => value.unwrap))(
        _.instanceTenancy
      )
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(offeringType.map(value => value.unwrap))(_.offeringType)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeReservedInstancesOfferingsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeReservedInstancesOfferingsRequest
      .wrap(buildAwsValue())
}
object DescribeReservedInstancesOfferingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeReservedInstancesOfferingsRequest =
      zio.aws.ec2.model.DescribeReservedInstancesOfferingsRequest(
        availabilityZone.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        includeMarketplace.map(value => value),
        instanceType.map(value => value),
        maxDuration.map(value => value),
        maxInstanceCount.map(value => value),
        minDuration.map(value => value),
        offeringClass.map(value => value),
        productDescription.map(value => value),
        reservedInstancesOfferingIds.map(value => value),
        instanceTenancy.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        offeringType.map(value => value)
      )
    def availabilityZone: Option[String]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def includeMarketplace: Option[Boolean]
    def instanceType: Option[zio.aws.ec2.model.InstanceType]
    def maxDuration: Option[Long]
    def maxInstanceCount: Option[Integer]
    def minDuration: Option[Long]
    def offeringClass: Option[zio.aws.ec2.model.OfferingClassType]
    def productDescription: Option[zio.aws.ec2.model.RIProductDescription]
    def reservedInstancesOfferingIds: Option[List[ReservedInstancesOfferingId]]
    def instanceTenancy: Option[zio.aws.ec2.model.Tenancy]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def offeringType: Option[zio.aws.ec2.model.OfferingTypeValues]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getIncludeMarketplace: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeMarketplace", includeMarketplace)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getMaxDuration: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("maxDuration", maxDuration)
    def getMaxInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxInstanceCount", maxInstanceCount)
    def getMinDuration: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("minDuration", minDuration)
    def getOfferingClass
        : ZIO[Any, AwsError, zio.aws.ec2.model.OfferingClassType] =
      AwsError.unwrapOptionField("offeringClass", offeringClass)
    def getProductDescription
        : ZIO[Any, AwsError, zio.aws.ec2.model.RIProductDescription] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getReservedInstancesOfferingIds
        : ZIO[Any, AwsError, List[ReservedInstancesOfferingId]] =
      AwsError.unwrapOptionField(
        "reservedInstancesOfferingIds",
        reservedInstancesOfferingIds
      )
    def getInstanceTenancy: ZIO[Any, AwsError, zio.aws.ec2.model.Tenancy] =
      AwsError.unwrapOptionField("instanceTenancy", instanceTenancy)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOfferingType
        : ZIO[Any, AwsError, zio.aws.ec2.model.OfferingTypeValues] =
      AwsError.unwrapOptionField("offeringType", offeringType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest
  ) extends zio.aws.ec2.model.DescribeReservedInstancesOfferingsRequest.ReadOnly {
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val includeMarketplace: Option[Boolean] =
      scala.Option(impl.includeMarketplace()).map(value => value: Boolean)
    override val instanceType: Option[zio.aws.ec2.model.InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val maxDuration: Option[Long] =
      scala.Option(impl.maxDuration()).map(value => value: Long)
    override val maxInstanceCount: Option[Integer] = scala
      .Option(impl.maxInstanceCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val minDuration: Option[Long] =
      scala.Option(impl.minDuration()).map(value => value: Long)
    override val offeringClass: Option[zio.aws.ec2.model.OfferingClassType] =
      scala
        .Option(impl.offeringClass())
        .map(value => zio.aws.ec2.model.OfferingClassType.wrap(value))
    override val productDescription
        : Option[zio.aws.ec2.model.RIProductDescription] = scala
      .Option(impl.productDescription())
      .map(value => zio.aws.ec2.model.RIProductDescription.wrap(value))
    override val reservedInstancesOfferingIds
        : Option[List[ReservedInstancesOfferingId]] = scala
      .Option(impl.reservedInstancesOfferingIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.ReservedInstancesOfferingId(item)
        }.toList
      )
    override val instanceTenancy: Option[zio.aws.ec2.model.Tenancy] = scala
      .Option(impl.instanceTenancy())
      .map(value => zio.aws.ec2.model.Tenancy.wrap(value))
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val offeringType: Option[zio.aws.ec2.model.OfferingTypeValues] =
      scala
        .Option(impl.offeringType())
        .map(value => zio.aws.ec2.model.OfferingTypeValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest
  ): zio.aws.ec2.model.DescribeReservedInstancesOfferingsRequest.ReadOnly =
    new Wrapper(impl)
}
