package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  NextToken,
  DescribeExportImageTasksMaxResults,
  ExportImageTaskId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeExportImageTasksRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    exportImageTaskIds: Option[Iterable[ExportImageTaskId]] = None,
    maxResults: Option[DescribeExportImageTasksMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksRequest = {
    import DescribeExportImageTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        exportImageTaskIds.map(value =>
          value.map { item =>
            ExportImageTaskId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.exportImageTaskIds)
      .optionallyWith(
        maxResults.map(value =>
          DescribeExportImageTasksMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeExportImageTasksRequest.ReadOnly =
    zio.aws.ec2.model.DescribeExportImageTasksRequest.wrap(buildAwsValue())
}
object DescribeExportImageTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeExportImageTasksRequest =
      zio.aws.ec2.model.DescribeExportImageTasksRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        exportImageTaskIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def exportImageTaskIds: Option[List[ExportImageTaskId]]
    def maxResults: Option[DescribeExportImageTasksMaxResults]
    def nextToken: Option[NextToken]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getExportImageTaskIds: ZIO[Any, AwsError, List[ExportImageTaskId]] =
      AwsError.unwrapOptionField("exportImageTaskIds", exportImageTaskIds)
    def getMaxResults: ZIO[Any, AwsError, DescribeExportImageTasksMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksRequest
  ) extends zio.aws.ec2.model.DescribeExportImageTasksRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val exportImageTaskIds: Option[List[ExportImageTaskId]] = scala
      .Option(impl.exportImageTaskIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.ExportImageTaskId(item)
        }.toList
      )
    override val maxResults: Option[DescribeExportImageTasksMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.DescribeExportImageTasksMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksRequest
  ): zio.aws.ec2.model.DescribeExportImageTasksRequest.ReadOnly = new Wrapper(
    impl
  )
}
