package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEgressOnlyInternetGatewaysResponse(
    egressOnlyInternetGateways: Option[
      Iterable[zio.aws.ec2.model.EgressOnlyInternetGateway]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysResponse = {
    import DescribeEgressOnlyInternetGatewaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysResponse
      .builder()
      .optionallyWith(
        egressOnlyInternetGateways.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.egressOnlyInternetGateways)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysResponse.ReadOnly =
    zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysResponse
      .wrap(buildAwsValue())
}
object DescribeEgressOnlyInternetGatewaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysResponse =
      zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysResponse(
        egressOnlyInternetGateways.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def egressOnlyInternetGateways
        : Option[List[zio.aws.ec2.model.EgressOnlyInternetGateway.ReadOnly]]
    def nextToken: Option[String]
    def getEgressOnlyInternetGateways: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.EgressOnlyInternetGateway.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "egressOnlyInternetGateways",
      egressOnlyInternetGateways
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysResponse
  ) extends zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysResponse.ReadOnly {
    override val egressOnlyInternetGateways
        : Option[List[zio.aws.ec2.model.EgressOnlyInternetGateway.ReadOnly]] =
      scala
        .Option(impl.egressOnlyInternetGateways())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.EgressOnlyInternetGateway.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysResponse
  ): zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysResponse.ReadOnly =
    new Wrapper(impl)
}
