package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteQueuedReservedInstancesResponse(
    successfulQueuedPurchaseDeletions: Option[
      Iterable[zio.aws.ec2.model.SuccessfulQueuedPurchaseDeletion]
    ] = None,
    failedQueuedPurchaseDeletions: Option[
      Iterable[zio.aws.ec2.model.FailedQueuedPurchaseDeletion]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesResponse = {
    import DeleteQueuedReservedInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesResponse
      .builder()
      .optionallyWith(
        successfulQueuedPurchaseDeletions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.successfulQueuedPurchaseDeletions)
      .optionallyWith(
        failedQueuedPurchaseDeletions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedQueuedPurchaseDeletions)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteQueuedReservedInstancesResponse.ReadOnly =
    zio.aws.ec2.model.DeleteQueuedReservedInstancesResponse
      .wrap(buildAwsValue())
}
object DeleteQueuedReservedInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteQueuedReservedInstancesResponse =
      zio.aws.ec2.model.DeleteQueuedReservedInstancesResponse(
        successfulQueuedPurchaseDeletions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failedQueuedPurchaseDeletions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successfulQueuedPurchaseDeletions: Option[
      List[zio.aws.ec2.model.SuccessfulQueuedPurchaseDeletion.ReadOnly]
    ]
    def failedQueuedPurchaseDeletions
        : Option[List[zio.aws.ec2.model.FailedQueuedPurchaseDeletion.ReadOnly]]
    def getSuccessfulQueuedPurchaseDeletions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SuccessfulQueuedPurchaseDeletion.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "successfulQueuedPurchaseDeletions",
      successfulQueuedPurchaseDeletions
    )
    def getFailedQueuedPurchaseDeletions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.FailedQueuedPurchaseDeletion.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "failedQueuedPurchaseDeletions",
      failedQueuedPurchaseDeletions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesResponse
  ) extends zio.aws.ec2.model.DeleteQueuedReservedInstancesResponse.ReadOnly {
    override val successfulQueuedPurchaseDeletions: Option[
      List[zio.aws.ec2.model.SuccessfulQueuedPurchaseDeletion.ReadOnly]
    ] = scala
      .Option(impl.successfulQueuedPurchaseDeletions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SuccessfulQueuedPurchaseDeletion.wrap(item)
        }.toList
      )
    override val failedQueuedPurchaseDeletions: Option[
      List[zio.aws.ec2.model.FailedQueuedPurchaseDeletion.ReadOnly]
    ] = scala
      .Option(impl.failedQueuedPurchaseDeletions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.FailedQueuedPurchaseDeletion.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesResponse
  ): zio.aws.ec2.model.DeleteQueuedReservedInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
