package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateVpcPeeringConnectionRequest(
    peerOwnerId: Option[String] = None,
    peerVpcId: Option[String] = None,
    vpcId: Option[VpcId] = None,
    peerRegion: Option[String] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionRequest = {
    import CreateVpcPeeringConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionRequest
      .builder()
      .optionallyWith(peerOwnerId.map(value => value: java.lang.String))(
        _.peerOwnerId
      )
      .optionallyWith(peerVpcId.map(value => value: java.lang.String))(
        _.peerVpcId
      )
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(peerRegion.map(value => value: java.lang.String))(
        _.peerRegion
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateVpcPeeringConnectionRequest.ReadOnly =
    zio.aws.ec2.model.CreateVpcPeeringConnectionRequest.wrap(buildAwsValue())
}
object CreateVpcPeeringConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVpcPeeringConnectionRequest =
      zio.aws.ec2.model.CreateVpcPeeringConnectionRequest(
        peerOwnerId.map(value => value),
        peerVpcId.map(value => value),
        vpcId.map(value => value),
        peerRegion.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def peerOwnerId: Option[String]
    def peerVpcId: Option[String]
    def vpcId: Option[VpcId]
    def peerRegion: Option[String]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getPeerOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("peerOwnerId", peerOwnerId)
    def getPeerVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("peerVpcId", peerVpcId)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getPeerRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("peerRegion", peerRegion)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionRequest
  ) extends zio.aws.ec2.model.CreateVpcPeeringConnectionRequest.ReadOnly {
    override val peerOwnerId: Option[String] =
      scala.Option(impl.peerOwnerId()).map(value => value: String)
    override val peerVpcId: Option[String] =
      scala.Option(impl.peerVpcId()).map(value => value: String)
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.ec2.model.primitives.VpcId(value))
    override val peerRegion: Option[String] =
      scala.Option(impl.peerRegion()).map(value => value: String)
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionRequest
  ): zio.aws.ec2.model.CreateVpcPeeringConnectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
