package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayMulticastDomainRequest(
    transitGatewayId: TransitGatewayId,
    options: Option[
      zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions
    ] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequest = {
    import CreateTransitGatewayMulticastDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequest
      .builder()
      .transitGatewayId(
        TransitGatewayId.unwrap(transitGatewayId): java.lang.String
      )
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequest.ReadOnly =
    zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequest
      .wrap(buildAwsValue())
}
object CreateTransitGatewayMulticastDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequest =
      zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequest(
        transitGatewayId,
        options.map(value => value.asEditable),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayId: TransitGatewayId
    def options: Option[
      zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions.ReadOnly
    ]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getTransitGatewayId: ZIO[Any, Nothing, TransitGatewayId] =
      ZIO.succeed(transitGatewayId)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequest
  ) extends zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequest.ReadOnly {
    override val transitGatewayId: TransitGatewayId =
      zio.aws.ec2.model.primitives.TransitGatewayId(impl.transitGatewayId())
    override val options: Option[
      zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions.ReadOnly
    ] = scala
      .Option(impl.options())
      .map(value =>
        zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions
          .wrap(value)
      )
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequest
  ): zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequest.ReadOnly =
    new Wrapper(impl)
}
