package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayAttachmentId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayConnectPeerRequest(
    transitGatewayAttachmentId: TransitGatewayAttachmentId,
    transitGatewayAddress: Option[String] = None,
    peerAddress: String,
    bgpOptions: Option[
      zio.aws.ec2.model.TransitGatewayConnectRequestBgpOptions
    ] = None,
    insideCidrBlocks: Iterable[String],
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectPeerRequest = {
    import CreateTransitGatewayConnectPeerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectPeerRequest
      .builder()
      .transitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transitGatewayAttachmentId
        ): java.lang.String
      )
      .optionallyWith(
        transitGatewayAddress.map(value => value: java.lang.String)
      )(_.transitGatewayAddress)
      .peerAddress(peerAddress: java.lang.String)
      .optionallyWith(bgpOptions.map(value => value.buildAwsValue()))(
        _.bgpOptions
      )
      .insideCidrBlocks(insideCidrBlocks.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateTransitGatewayConnectPeerRequest.ReadOnly =
    zio.aws.ec2.model.CreateTransitGatewayConnectPeerRequest
      .wrap(buildAwsValue())
}
object CreateTransitGatewayConnectPeerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectPeerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateTransitGatewayConnectPeerRequest =
      zio.aws.ec2.model.CreateTransitGatewayConnectPeerRequest(
        transitGatewayAttachmentId,
        transitGatewayAddress.map(value => value),
        peerAddress,
        bgpOptions.map(value => value.asEditable),
        insideCidrBlocks,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayAttachmentId: TransitGatewayAttachmentId
    def transitGatewayAddress: Option[String]
    def peerAddress: String
    def bgpOptions: Option[
      zio.aws.ec2.model.TransitGatewayConnectRequestBgpOptions.ReadOnly
    ]
    def insideCidrBlocks: List[String]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transitGatewayAttachmentId)
    def getTransitGatewayAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayAddress", transitGatewayAddress)
    def getPeerAddress: ZIO[Any, Nothing, String] = ZIO.succeed(peerAddress)
    def getBgpOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayConnectRequestBgpOptions.ReadOnly
    ] = AwsError.unwrapOptionField("bgpOptions", bgpOptions)
    def getInsideCidrBlocks: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(insideCidrBlocks)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectPeerRequest
  ) extends zio.aws.ec2.model.CreateTransitGatewayConnectPeerRequest.ReadOnly {
    override val transitGatewayAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.transitGatewayAttachmentId())
    override val transitGatewayAddress: Option[String] =
      scala.Option(impl.transitGatewayAddress()).map(value => value: String)
    override val peerAddress: String = impl.peerAddress(): String
    override val bgpOptions: Option[
      zio.aws.ec2.model.TransitGatewayConnectRequestBgpOptions.ReadOnly
    ] = scala
      .Option(impl.bgpOptions())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayConnectRequestBgpOptions.wrap(value)
      )
    override val insideCidrBlocks: List[String] = impl
      .insideCidrBlocks()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectPeerRequest
  ): zio.aws.ec2.model.CreateTransitGatewayConnectPeerRequest.ReadOnly =
    new Wrapper(impl)
}
