package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSpotDatafeedSubscriptionResponse(
    spotDatafeedSubscription: Option[
      zio.aws.ec2.model.SpotDatafeedSubscription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionResponse = {
    import CreateSpotDatafeedSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionResponse
      .builder()
      .optionallyWith(
        spotDatafeedSubscription.map(value => value.buildAwsValue())
      )(_.spotDatafeedSubscription)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateSpotDatafeedSubscriptionResponse.ReadOnly =
    zio.aws.ec2.model.CreateSpotDatafeedSubscriptionResponse
      .wrap(buildAwsValue())
}
object CreateSpotDatafeedSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateSpotDatafeedSubscriptionResponse =
      zio.aws.ec2.model.CreateSpotDatafeedSubscriptionResponse(
        spotDatafeedSubscription.map(value => value.asEditable)
      )
    def spotDatafeedSubscription
        : Option[zio.aws.ec2.model.SpotDatafeedSubscription.ReadOnly]
    def getSpotDatafeedSubscription: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.SpotDatafeedSubscription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "spotDatafeedSubscription",
      spotDatafeedSubscription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionResponse
  ) extends zio.aws.ec2.model.CreateSpotDatafeedSubscriptionResponse.ReadOnly {
    override val spotDatafeedSubscription
        : Option[zio.aws.ec2.model.SpotDatafeedSubscription.ReadOnly] = scala
      .Option(impl.spotDatafeedSubscription())
      .map(value => zio.aws.ec2.model.SpotDatafeedSubscription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionResponse
  ): zio.aws.ec2.model.CreateSpotDatafeedSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
