package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSpotDatafeedSubscriptionRequest(
    bucket: String,
    prefix: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionRequest = {
    import CreateSpotDatafeedSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateSpotDatafeedSubscriptionRequest.ReadOnly =
    zio.aws.ec2.model.CreateSpotDatafeedSubscriptionRequest
      .wrap(buildAwsValue())
}
object CreateSpotDatafeedSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateSpotDatafeedSubscriptionRequest =
      zio.aws.ec2.model.CreateSpotDatafeedSubscriptionRequest(
        bucket,
        prefix.map(value => value)
      )
    def bucket: String
    def prefix: Option[String]
    def getBucket: ZIO[Any, Nothing, String] = ZIO.succeed(bucket)
    def getPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionRequest
  ) extends zio.aws.ec2.model.CreateSpotDatafeedSubscriptionRequest.ReadOnly {
    override val bucket: String = impl.bucket(): String
    override val prefix: Option[String] =
      scala.Option(impl.prefix()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionRequest
  ): zio.aws.ec2.model.CreateSpotDatafeedSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
