package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateImageRequest(
    blockDeviceMappings: Option[
      Iterable[zio.aws.ec2.model.BlockDeviceMapping]
    ] = None,
    description: Option[String] = None,
    instanceId: InstanceId,
    name: String,
    noReboot: Option[Boolean] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateImageRequest = {
    import CreateImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateImageRequest
      .builder()
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .name(name: java.lang.String)
      .optionallyWith(noReboot.map(value => value: java.lang.Boolean))(
        _.noReboot
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateImageRequest.ReadOnly =
    zio.aws.ec2.model.CreateImageRequest.wrap(buildAwsValue())
}
object CreateImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateImageRequest =
      zio.aws.ec2.model.CreateImageRequest(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        description.map(value => value),
        instanceId,
        name,
        noReboot.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def blockDeviceMappings
        : Option[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]]
    def description: Option[String]
    def instanceId: InstanceId
    def name: String
    def noReboot: Option[Boolean]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.BlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getNoReboot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("noReboot", noReboot)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateImageRequest
  ) extends zio.aws.ec2.model.CreateImageRequest.ReadOnly {
    override val blockDeviceMappings
        : Option[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]] = scala
      .Option(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.BlockDeviceMapping.wrap(item)
        }.toList
      )
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val name: String = impl.name(): String
    override val noReboot: Option[Boolean] =
      scala.Option(impl.noReboot()).map(value => value: Boolean)
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateImageRequest
  ): zio.aws.ec2.model.CreateImageRequest.ReadOnly = new Wrapper(impl)
}
