package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ConversionTask(
    conversionTaskId: Option[String] = None,
    expirationTime: Option[String] = None,
    importInstance: Option[zio.aws.ec2.model.ImportInstanceTaskDetails] = None,
    importVolume: Option[zio.aws.ec2.model.ImportVolumeTaskDetails] = None,
    state: Option[zio.aws.ec2.model.ConversionTaskState] = None,
    statusMessage: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ConversionTask = {
    import ConversionTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ConversionTask
      .builder()
      .optionallyWith(conversionTaskId.map(value => value: java.lang.String))(
        _.conversionTaskId
      )
      .optionallyWith(expirationTime.map(value => value: java.lang.String))(
        _.expirationTime
      )
      .optionallyWith(importInstance.map(value => value.buildAwsValue()))(
        _.importInstance
      )
      .optionallyWith(importVolume.map(value => value.buildAwsValue()))(
        _.importVolume
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ConversionTask.ReadOnly =
    zio.aws.ec2.model.ConversionTask.wrap(buildAwsValue())
}
object ConversionTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ConversionTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ConversionTask =
      zio.aws.ec2.model.ConversionTask(
        conversionTaskId.map(value => value),
        expirationTime.map(value => value),
        importInstance.map(value => value.asEditable),
        importVolume.map(value => value.asEditable),
        state.map(value => value),
        statusMessage.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def conversionTaskId: Option[String]
    def expirationTime: Option[String]
    def importInstance
        : Option[zio.aws.ec2.model.ImportInstanceTaskDetails.ReadOnly]
    def importVolume: Option[zio.aws.ec2.model.ImportVolumeTaskDetails.ReadOnly]
    def state: Option[zio.aws.ec2.model.ConversionTaskState]
    def statusMessage: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getConversionTaskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("conversionTaskId", conversionTaskId)
    def getExpirationTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("expirationTime", expirationTime)
    def getImportInstance: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ImportInstanceTaskDetails.ReadOnly
    ] = AwsError.unwrapOptionField("importInstance", importInstance)
    def getImportVolume: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ImportVolumeTaskDetails.ReadOnly
    ] = AwsError.unwrapOptionField("importVolume", importVolume)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.ConversionTaskState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ConversionTask
  ) extends zio.aws.ec2.model.ConversionTask.ReadOnly {
    override val conversionTaskId: Option[String] =
      scala.Option(impl.conversionTaskId()).map(value => value: String)
    override val expirationTime: Option[String] =
      scala.Option(impl.expirationTime()).map(value => value: String)
    override val importInstance
        : Option[zio.aws.ec2.model.ImportInstanceTaskDetails.ReadOnly] = scala
      .Option(impl.importInstance())
      .map(value => zio.aws.ec2.model.ImportInstanceTaskDetails.wrap(value))
    override val importVolume
        : Option[zio.aws.ec2.model.ImportVolumeTaskDetails.ReadOnly] = scala
      .Option(impl.importVolume())
      .map(value => zio.aws.ec2.model.ImportVolumeTaskDetails.wrap(value))
    override val state: Option[zio.aws.ec2.model.ConversionTaskState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.ConversionTaskState.wrap(value))
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ConversionTask
  ): zio.aws.ec2.model.ConversionTask.ReadOnly = new Wrapper(impl)
}
