package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ConfirmProductInstanceResponse(
    ownerId: Option[String] = None,
    returnValue: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceResponse = {
    import ConfirmProductInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceResponse
      .builder()
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ConfirmProductInstanceResponse.ReadOnly =
    zio.aws.ec2.model.ConfirmProductInstanceResponse.wrap(buildAwsValue())
}
object ConfirmProductInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ConfirmProductInstanceResponse =
      zio.aws.ec2.model.ConfirmProductInstanceResponse(
        ownerId.map(value => value),
        returnValue.map(value => value)
      )
    def ownerId: Option[String]
    def returnValue: Option[Boolean]
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceResponse
  ) extends zio.aws.ec2.model.ConfirmProductInstanceResponse.ReadOnly {
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceResponse
  ): zio.aws.ec2.model.ConfirmProductInstanceResponse.ReadOnly = new Wrapper(
    impl
  )
}
