package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClientVpnConnection(
    clientVpnEndpointId: Option[String] = None,
    timestamp: Option[String] = None,
    connectionId: Option[String] = None,
    username: Option[String] = None,
    connectionEstablishedTime: Option[String] = None,
    ingressBytes: Option[String] = None,
    egressBytes: Option[String] = None,
    ingressPackets: Option[String] = None,
    egressPackets: Option[String] = None,
    clientIp: Option[String] = None,
    commonName: Option[String] = None,
    status: Option[zio.aws.ec2.model.ClientVpnConnectionStatus] = None,
    connectionEndTime: Option[String] = None,
    postureComplianceStatuses: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClientVpnConnection = {
    import ClientVpnConnection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClientVpnConnection
      .builder()
      .optionallyWith(
        clientVpnEndpointId.map(value => value: java.lang.String)
      )(_.clientVpnEndpointId)
      .optionallyWith(timestamp.map(value => value: java.lang.String))(
        _.timestamp
      )
      .optionallyWith(connectionId.map(value => value: java.lang.String))(
        _.connectionId
      )
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        connectionEstablishedTime.map(value => value: java.lang.String)
      )(_.connectionEstablishedTime)
      .optionallyWith(ingressBytes.map(value => value: java.lang.String))(
        _.ingressBytes
      )
      .optionallyWith(egressBytes.map(value => value: java.lang.String))(
        _.egressBytes
      )
      .optionallyWith(ingressPackets.map(value => value: java.lang.String))(
        _.ingressPackets
      )
      .optionallyWith(egressPackets.map(value => value: java.lang.String))(
        _.egressPackets
      )
      .optionallyWith(clientIp.map(value => value: java.lang.String))(
        _.clientIp
      )
      .optionallyWith(commonName.map(value => value: java.lang.String))(
        _.commonName
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(connectionEndTime.map(value => value: java.lang.String))(
        _.connectionEndTime
      )
      .optionallyWith(
        postureComplianceStatuses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.postureComplianceStatuses)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClientVpnConnection.ReadOnly =
    zio.aws.ec2.model.ClientVpnConnection.wrap(buildAwsValue())
}
object ClientVpnConnection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClientVpnConnection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClientVpnConnection =
      zio.aws.ec2.model.ClientVpnConnection(
        clientVpnEndpointId.map(value => value),
        timestamp.map(value => value),
        connectionId.map(value => value),
        username.map(value => value),
        connectionEstablishedTime.map(value => value),
        ingressBytes.map(value => value),
        egressBytes.map(value => value),
        ingressPackets.map(value => value),
        egressPackets.map(value => value),
        clientIp.map(value => value),
        commonName.map(value => value),
        status.map(value => value.asEditable),
        connectionEndTime.map(value => value),
        postureComplianceStatuses.map(value => value)
      )
    def clientVpnEndpointId: Option[String]
    def timestamp: Option[String]
    def connectionId: Option[String]
    def username: Option[String]
    def connectionEstablishedTime: Option[String]
    def ingressBytes: Option[String]
    def egressBytes: Option[String]
    def ingressPackets: Option[String]
    def egressPackets: Option[String]
    def clientIp: Option[String]
    def commonName: Option[String]
    def status: Option[zio.aws.ec2.model.ClientVpnConnectionStatus.ReadOnly]
    def connectionEndTime: Option[String]
    def postureComplianceStatuses: Option[List[String]]
    def getClientVpnEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientVpnEndpointId", clientVpnEndpointId)
    def getTimestamp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getConnectionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getConnectionEstablishedTime: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("connectionEstablishedTime", connectionEstablishedTime)
    def getIngressBytes: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ingressBytes", ingressBytes)
    def getEgressBytes: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("egressBytes", egressBytes)
    def getIngressPackets: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ingressPackets", ingressPackets)
    def getEgressPackets: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("egressPackets", egressPackets)
    def getClientIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientIp", clientIp)
    def getCommonName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("commonName", commonName)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientVpnConnectionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getConnectionEndTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectionEndTime", connectionEndTime)
    def getPostureComplianceStatuses: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "postureComplianceStatuses",
        postureComplianceStatuses
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnConnection
  ) extends zio.aws.ec2.model.ClientVpnConnection.ReadOnly {
    override val clientVpnEndpointId: Option[String] =
      scala.Option(impl.clientVpnEndpointId()).map(value => value: String)
    override val timestamp: Option[String] =
      scala.Option(impl.timestamp()).map(value => value: String)
    override val connectionId: Option[String] =
      scala.Option(impl.connectionId()).map(value => value: String)
    override val username: Option[String] =
      scala.Option(impl.username()).map(value => value: String)
    override val connectionEstablishedTime: Option[String] =
      scala.Option(impl.connectionEstablishedTime()).map(value => value: String)
    override val ingressBytes: Option[String] =
      scala.Option(impl.ingressBytes()).map(value => value: String)
    override val egressBytes: Option[String] =
      scala.Option(impl.egressBytes()).map(value => value: String)
    override val ingressPackets: Option[String] =
      scala.Option(impl.ingressPackets()).map(value => value: String)
    override val egressPackets: Option[String] =
      scala.Option(impl.egressPackets()).map(value => value: String)
    override val clientIp: Option[String] =
      scala.Option(impl.clientIp()).map(value => value: String)
    override val commonName: Option[String] =
      scala.Option(impl.commonName()).map(value => value: String)
    override val status
        : Option[zio.aws.ec2.model.ClientVpnConnectionStatus.ReadOnly] = scala
      .Option(impl.status())
      .map(value => zio.aws.ec2.model.ClientVpnConnectionStatus.wrap(value))
    override val connectionEndTime: Option[String] =
      scala.Option(impl.connectionEndTime()).map(value => value: String)
    override val postureComplianceStatuses: Option[List[String]] = scala
      .Option(impl.postureComplianceStatuses())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnConnection
  ): zio.aws.ec2.model.ClientVpnConnection.ReadOnly = new Wrapper(impl)
}
