package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CidrBlock(cidrBlock: Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.CidrBlock = {
    import CidrBlock.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CidrBlock
      .builder()
      .optionallyWith(cidrBlock.map(value => value: java.lang.String))(
        _.cidrBlock
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CidrBlock.ReadOnly =
    zio.aws.ec2.model.CidrBlock.wrap(buildAwsValue())
}
object CidrBlock {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.CidrBlock] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CidrBlock =
      zio.aws.ec2.model.CidrBlock(cidrBlock.map(value => value))
    def cidrBlock: Option[String]
    def getCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CidrBlock
  ) extends zio.aws.ec2.model.CidrBlock.ReadOnly {
    override val cidrBlock: Option[String] =
      scala.Option(impl.cidrBlock()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CidrBlock
  ): zio.aws.ec2.model.CidrBlock.ReadOnly = new Wrapper(impl)
}
