package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CancelledSpotInstanceRequest(
    spotInstanceRequestId: Option[String] = None,
    state: Option[zio.aws.ec2.model.CancelSpotInstanceRequestState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelledSpotInstanceRequest = {
    import CancelledSpotInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelledSpotInstanceRequest
      .builder()
      .optionallyWith(
        spotInstanceRequestId.map(value => value: java.lang.String)
      )(_.spotInstanceRequestId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelledSpotInstanceRequest.ReadOnly =
    zio.aws.ec2.model.CancelledSpotInstanceRequest.wrap(buildAwsValue())
}
object CancelledSpotInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelledSpotInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelledSpotInstanceRequest =
      zio.aws.ec2.model.CancelledSpotInstanceRequest(
        spotInstanceRequestId.map(value => value),
        state.map(value => value)
      )
    def spotInstanceRequestId: Option[String]
    def state: Option[zio.aws.ec2.model.CancelSpotInstanceRequestState]
    def getSpotInstanceRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotInstanceRequestId", spotInstanceRequestId)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.CancelSpotInstanceRequestState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelledSpotInstanceRequest
  ) extends zio.aws.ec2.model.CancelledSpotInstanceRequest.ReadOnly {
    override val spotInstanceRequestId: Option[String] =
      scala.Option(impl.spotInstanceRequestId()).map(value => value: String)
    override val state
        : Option[zio.aws.ec2.model.CancelSpotInstanceRequestState] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.ec2.model.CancelSpotInstanceRequestState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelledSpotInstanceRequest
  ): zio.aws.ec2.model.CancelledSpotInstanceRequest.ReadOnly = new Wrapper(impl)
}
