package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociateTransitGatewayRouteTableResponse(
    association: Option[zio.aws.ec2.model.TransitGatewayAssociation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayRouteTableResponse = {
    import AssociateTransitGatewayRouteTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayRouteTableResponse
      .builder()
      .optionallyWith(association.map(value => value.buildAwsValue()))(
        _.association
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssociateTransitGatewayRouteTableResponse.ReadOnly =
    zio.aws.ec2.model.AssociateTransitGatewayRouteTableResponse
      .wrap(buildAwsValue())
}
object AssociateTransitGatewayRouteTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayRouteTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.AssociateTransitGatewayRouteTableResponse =
      zio.aws.ec2.model.AssociateTransitGatewayRouteTableResponse(
        association.map(value => value.asEditable)
      )
    def association
        : Option[zio.aws.ec2.model.TransitGatewayAssociation.ReadOnly]
    def getAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("association", association)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayRouteTableResponse
  ) extends zio.aws.ec2.model.AssociateTransitGatewayRouteTableResponse.ReadOnly {
    override val association
        : Option[zio.aws.ec2.model.TransitGatewayAssociation.ReadOnly] = scala
      .Option(impl.association())
      .map(value => zio.aws.ec2.model.TransitGatewayAssociation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayRouteTableResponse
  ): zio.aws.ec2.model.AssociateTransitGatewayRouteTableResponse.ReadOnly =
    new Wrapper(impl)
}
