package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, IpamPoolId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AllocateIpamPoolCidrRequest(
    ipamPoolId: IpamPoolId,
    cidr: Option[String] = None,
    netmaskLength: Option[Integer] = None,
    clientToken: Option[String] = None,
    description: Option[String] = None,
    previewNextCidr: Option[Boolean] = None,
    disallowedCidrs: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrRequest = {
    import AllocateIpamPoolCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrRequest
      .builder()
      .ipamPoolId(IpamPoolId.unwrap(ipamPoolId): java.lang.String)
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .optionallyWith(
        netmaskLength.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.netmaskLength)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(previewNextCidr.map(value => value: java.lang.Boolean))(
        _.previewNextCidr
      )
      .optionallyWith(
        disallowedCidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.disallowedCidrs)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AllocateIpamPoolCidrRequest.ReadOnly =
    zio.aws.ec2.model.AllocateIpamPoolCidrRequest.wrap(buildAwsValue())
}
object AllocateIpamPoolCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AllocateIpamPoolCidrRequest =
      zio.aws.ec2.model.AllocateIpamPoolCidrRequest(
        ipamPoolId,
        cidr.map(value => value),
        netmaskLength.map(value => value),
        clientToken.map(value => value),
        description.map(value => value),
        previewNextCidr.map(value => value),
        disallowedCidrs.map(value => value)
      )
    def ipamPoolId: IpamPoolId
    def cidr: Option[String]
    def netmaskLength: Option[Integer]
    def clientToken: Option[String]
    def description: Option[String]
    def previewNextCidr: Option[Boolean]
    def disallowedCidrs: Option[List[String]]
    def getIpamPoolId: ZIO[Any, Nothing, IpamPoolId] = ZIO.succeed(ipamPoolId)
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getNetmaskLength: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("netmaskLength", netmaskLength)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getPreviewNextCidr: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("previewNextCidr", previewNextCidr)
    def getDisallowedCidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("disallowedCidrs", disallowedCidrs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrRequest
  ) extends zio.aws.ec2.model.AllocateIpamPoolCidrRequest.ReadOnly {
    override val ipamPoolId: IpamPoolId =
      zio.aws.ec2.model.primitives.IpamPoolId(impl.ipamPoolId())
    override val cidr: Option[String] =
      scala.Option(impl.cidr()).map(value => value: String)
    override val netmaskLength: Option[Integer] = scala
      .Option(impl.netmaskLength())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val previewNextCidr: Option[Boolean] =
      scala.Option(impl.previewNextCidr()).map(value => value: Boolean)
    override val disallowedCidrs: Option[List[String]] = scala
      .Option(impl.disallowedCidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrRequest
  ): zio.aws.ec2.model.AllocateIpamPoolCidrRequest.ReadOnly = new Wrapper(impl)
}
