package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ActivityStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.ActivityStatus
}
object ActivityStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ActivityStatus
  ): zio.aws.ec2.model.ActivityStatus = value match {
    case software.amazon.awssdk.services.ec2.model.ActivityStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ActivityStatus.ERROR =>
      val r = error
      r
    case software.amazon.awssdk.services.ec2.model.ActivityStatus.PENDING_FULFILLMENT =>
      val r = pending_fulfillment
      r
    case software.amazon.awssdk.services.ec2.model.ActivityStatus.PENDING_TERMINATION =>
      val r = pending_termination
      r
    case software.amazon.awssdk.services.ec2.model.ActivityStatus.FULFILLED =>
      val r = fulfilled
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ActivityStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ActivityStatus =
      software.amazon.awssdk.services.ec2.model.ActivityStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object error extends zio.aws.ec2.model.ActivityStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ActivityStatus =
      software.amazon.awssdk.services.ec2.model.ActivityStatus.ERROR
  }
  case object pending_fulfillment extends zio.aws.ec2.model.ActivityStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ActivityStatus =
      software.amazon.awssdk.services.ec2.model.ActivityStatus.PENDING_FULFILLMENT
  }
  case object pending_termination extends zio.aws.ec2.model.ActivityStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ActivityStatus =
      software.amazon.awssdk.services.ec2.model.ActivityStatus.PENDING_TERMINATION
  }
  case object fulfilled extends zio.aws.ec2.model.ActivityStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ActivityStatus =
      software.amazon.awssdk.services.ec2.model.ActivityStatus.FULFILLED
  }
}
