package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TransitGatewayVpcAttachment(
    transitGatewayAttachmentId: Option[String] = None,
    transitGatewayId: Option[String] = None,
    vpcId: Option[String] = None,
    vpcOwnerId: Option[String] = None,
    state: Option[zio.aws.ec2.model.TransitGatewayAttachmentState] = None,
    subnetIds: Option[Iterable[String]] = None,
    creationTime: Option[DateTime] = None,
    options: Option[zio.aws.ec2.model.TransitGatewayVpcAttachmentOptions] =
      None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayVpcAttachment = {
    import TransitGatewayVpcAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayVpcAttachment
      .builder()
      .optionallyWith(
        transitGatewayAttachmentId.map(value => value: java.lang.String)
      )(_.transitGatewayAttachmentId)
      .optionallyWith(transitGatewayId.map(value => value: java.lang.String))(
        _.transitGatewayId
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(vpcOwnerId.map(value => value: java.lang.String))(
        _.vpcOwnerId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly =
    zio.aws.ec2.model.TransitGatewayVpcAttachment.wrap(buildAwsValue())
}
object TransitGatewayVpcAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayVpcAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayVpcAttachment =
      zio.aws.ec2.model.TransitGatewayVpcAttachment(
        transitGatewayAttachmentId.map(value => value),
        transitGatewayId.map(value => value),
        vpcId.map(value => value),
        vpcOwnerId.map(value => value),
        state.map(value => value),
        subnetIds.map(value => value),
        creationTime.map(value => value),
        options.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayAttachmentId: Option[String]
    def transitGatewayId: Option[String]
    def vpcId: Option[String]
    def vpcOwnerId: Option[String]
    def state: Option[zio.aws.ec2.model.TransitGatewayAttachmentState]
    def subnetIds: Option[List[String]]
    def creationTime: Option[DateTime]
    def options
        : Option[zio.aws.ec2.model.TransitGatewayVpcAttachmentOptions.ReadOnly]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTransitGatewayAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getTransitGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getVpcOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcOwnerId", vpcOwnerId)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayAttachmentState] =
      AwsError.unwrapOptionField("state", state)
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayVpcAttachmentOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayVpcAttachment
  ) extends zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly {
    override val transitGatewayAttachmentId: Option[String] = scala
      .Option(impl.transitGatewayAttachmentId())
      .map(value => value: String)
    override val transitGatewayId: Option[String] =
      scala.Option(impl.transitGatewayId()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val vpcOwnerId: Option[String] =
      scala.Option(impl.vpcOwnerId()).map(value => value: String)
    override val state
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.TransitGatewayAttachmentState.wrap(value))
    override val subnetIds: Option[List[String]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val creationTime: Option[DateTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val options: Option[
      zio.aws.ec2.model.TransitGatewayVpcAttachmentOptions.ReadOnly
    ] = scala
      .Option(impl.options())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayVpcAttachmentOptions.wrap(value)
      )
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayVpcAttachment
  ): zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly = new Wrapper(impl)
}
