package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayAttachmentId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransitGatewayPrefixListAttachment(
    transitGatewayAttachmentId: Option[TransitGatewayAttachmentId] = None,
    resourceType: Option[
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = None,
    resourceId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListAttachment = {
    import TransitGatewayPrefixListAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListAttachment
      .builder()
      .optionallyWith(
        transitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentId)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TransitGatewayPrefixListAttachment.ReadOnly =
    zio.aws.ec2.model.TransitGatewayPrefixListAttachment.wrap(buildAwsValue())
}
object TransitGatewayPrefixListAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayPrefixListAttachment =
      zio.aws.ec2.model.TransitGatewayPrefixListAttachment(
        transitGatewayAttachmentId.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value)
      )
    def transitGatewayAttachmentId: Option[TransitGatewayAttachmentId]
    def resourceType
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentResourceType]
    def resourceId: Option[String]
    def getTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListAttachment
  ) extends zio.aws.ec2.model.TransitGatewayPrefixListAttachment.ReadOnly {
    override val transitGatewayAttachmentId
        : Option[TransitGatewayAttachmentId] = scala
      .Option(impl.transitGatewayAttachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
      )
    override val resourceType
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayAttachmentResourceType.wrap(value)
      )
    override val resourceId: Option[String] =
      scala.Option(impl.resourceId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListAttachment
  ): zio.aws.ec2.model.TransitGatewayPrefixListAttachment.ReadOnly =
    new Wrapper(impl)
}
