package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ServiceDetail(
    serviceName: Option[String] = None,
    serviceId: Option[String] = None,
    serviceType: Option[Iterable[zio.aws.ec2.model.ServiceTypeDetail]] = None,
    availabilityZones: Option[Iterable[String]] = None,
    owner: Option[String] = None,
    baseEndpointDnsNames: Option[Iterable[String]] = None,
    privateDnsName: Option[String] = None,
    privateDnsNames: Option[Iterable[zio.aws.ec2.model.PrivateDnsDetails]] =
      None,
    vpcEndpointPolicySupported: Option[Boolean] = None,
    acceptanceRequired: Option[Boolean] = None,
    managesVpcEndpoints: Option[Boolean] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    privateDnsNameVerificationState: Option[zio.aws.ec2.model.DnsNameState] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ServiceDetail = {
    import ServiceDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ServiceDetail
      .builder()
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .optionallyWith(serviceId.map(value => value: java.lang.String))(
        _.serviceId
      )
      .optionallyWith(
        serviceType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceType)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(owner.map(value => value: java.lang.String))(_.owner)
      .optionallyWith(
        baseEndpointDnsNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.baseEndpointDnsNames)
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(
        privateDnsNames.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.privateDnsNames)
      .optionallyWith(
        vpcEndpointPolicySupported.map(value => value: java.lang.Boolean)
      )(_.vpcEndpointPolicySupported)
      .optionallyWith(
        acceptanceRequired.map(value => value: java.lang.Boolean)
      )(_.acceptanceRequired)
      .optionallyWith(
        managesVpcEndpoints.map(value => value: java.lang.Boolean)
      )(_.managesVpcEndpoints)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        privateDnsNameVerificationState.map(value => value.unwrap)
      )(_.privateDnsNameVerificationState)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ServiceDetail.ReadOnly =
    zio.aws.ec2.model.ServiceDetail.wrap(buildAwsValue())
}
object ServiceDetail {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.ServiceDetail] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ServiceDetail =
      zio.aws.ec2.model.ServiceDetail(
        serviceName.map(value => value),
        serviceId.map(value => value),
        serviceType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZones.map(value => value),
        owner.map(value => value),
        baseEndpointDnsNames.map(value => value),
        privateDnsName.map(value => value),
        privateDnsNames.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcEndpointPolicySupported.map(value => value),
        acceptanceRequired.map(value => value),
        managesVpcEndpoints.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        privateDnsNameVerificationState.map(value => value)
      )
    def serviceName: Option[String]
    def serviceId: Option[String]
    def serviceType: Option[List[zio.aws.ec2.model.ServiceTypeDetail.ReadOnly]]
    def availabilityZones: Option[List[String]]
    def owner: Option[String]
    def baseEndpointDnsNames: Option[List[String]]
    def privateDnsName: Option[String]
    def privateDnsNames
        : Option[List[zio.aws.ec2.model.PrivateDnsDetails.ReadOnly]]
    def vpcEndpointPolicySupported: Option[Boolean]
    def acceptanceRequired: Option[Boolean]
    def managesVpcEndpoints: Option[Boolean]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def privateDnsNameVerificationState: Option[zio.aws.ec2.model.DnsNameState]
    def getServiceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getServiceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getServiceType: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ServiceTypeDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("serviceType", serviceType)
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("owner", owner)
    def getBaseEndpointDnsNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("baseEndpointDnsNames", baseEndpointDnsNames)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getPrivateDnsNames: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.PrivateDnsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("privateDnsNames", privateDnsNames)
    def getVpcEndpointPolicySupported: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "vpcEndpointPolicySupported",
        vpcEndpointPolicySupported
      )
    def getAcceptanceRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("acceptanceRequired", acceptanceRequired)
    def getManagesVpcEndpoints: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("managesVpcEndpoints", managesVpcEndpoints)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPrivateDnsNameVerificationState
        : ZIO[Any, AwsError, zio.aws.ec2.model.DnsNameState] =
      AwsError.unwrapOptionField(
        "privateDnsNameVerificationState",
        privateDnsNameVerificationState
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ServiceDetail
  ) extends zio.aws.ec2.model.ServiceDetail.ReadOnly {
    override val serviceName: Option[String] =
      scala.Option(impl.serviceName()).map(value => value: String)
    override val serviceId: Option[String] =
      scala.Option(impl.serviceId()).map(value => value: String)
    override val serviceType
        : Option[List[zio.aws.ec2.model.ServiceTypeDetail.ReadOnly]] = scala
      .Option(impl.serviceType())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ServiceTypeDetail.wrap(item)
        }.toList
      )
    override val availabilityZones: Option[List[String]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val owner: Option[String] =
      scala.Option(impl.owner()).map(value => value: String)
    override val baseEndpointDnsNames: Option[List[String]] = scala
      .Option(impl.baseEndpointDnsNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val privateDnsName: Option[String] =
      scala.Option(impl.privateDnsName()).map(value => value: String)
    override val privateDnsNames
        : Option[List[zio.aws.ec2.model.PrivateDnsDetails.ReadOnly]] = scala
      .Option(impl.privateDnsNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.PrivateDnsDetails.wrap(item)
        }.toList
      )
    override val vpcEndpointPolicySupported: Option[Boolean] = scala
      .Option(impl.vpcEndpointPolicySupported())
      .map(value => value: Boolean)
    override val acceptanceRequired: Option[Boolean] =
      scala.Option(impl.acceptanceRequired()).map(value => value: Boolean)
    override val managesVpcEndpoints: Option[Boolean] =
      scala.Option(impl.managesVpcEndpoints()).map(value => value: Boolean)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val privateDnsNameVerificationState
        : Option[zio.aws.ec2.model.DnsNameState] = scala
      .Option(impl.privateDnsNameVerificationState())
      .map(value => zio.aws.ec2.model.DnsNameState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ServiceDetail
  ): zio.aws.ec2.model.ServiceDetail.ReadOnly = new Wrapper(impl)
}
