package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReservedInstancesOffering(
    availabilityZone: Option[String] = None,
    duration: Option[Long] = None,
    fixedPrice: Option[Float] = None,
    instanceType: Option[zio.aws.ec2.model.InstanceType] = None,
    productDescription: Option[zio.aws.ec2.model.RIProductDescription] = None,
    reservedInstancesOfferingId: Option[String] = None,
    usagePrice: Option[Float] = None,
    currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues] = None,
    instanceTenancy: Option[zio.aws.ec2.model.Tenancy] = None,
    marketplace: Option[Boolean] = None,
    offeringClass: Option[zio.aws.ec2.model.OfferingClassType] = None,
    offeringType: Option[zio.aws.ec2.model.OfferingTypeValues] = None,
    pricingDetails: Option[Iterable[zio.aws.ec2.model.PricingDetail]] = None,
    recurringCharges: Option[Iterable[zio.aws.ec2.model.RecurringCharge]] =
      None,
    scope: Option[zio.aws.ec2.model.Scope] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReservedInstancesOffering = {
    import ReservedInstancesOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReservedInstancesOffering
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(duration.map(value => value: java.lang.Long))(_.duration)
      .optionallyWith(fixedPrice.map(value => value: java.lang.Float))(
        _.fixedPrice
      )
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(productDescription.map(value => value.unwrap))(
        _.productDescription
      )
      .optionallyWith(
        reservedInstancesOfferingId.map(value => value: java.lang.String)
      )(_.reservedInstancesOfferingId)
      .optionallyWith(usagePrice.map(value => value: java.lang.Float))(
        _.usagePrice
      )
      .optionallyWith(currencyCode.map(value => value.unwrap))(_.currencyCode)
      .optionallyWith(instanceTenancy.map(value => value.unwrap))(
        _.instanceTenancy
      )
      .optionallyWith(marketplace.map(value => value: java.lang.Boolean))(
        _.marketplace
      )
      .optionallyWith(offeringClass.map(value => value.unwrap))(_.offeringClass)
      .optionallyWith(offeringType.map(value => value.unwrap))(_.offeringType)
      .optionallyWith(
        pricingDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pricingDetails)
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .optionallyWith(scope.map(value => value.unwrap))(_.scope)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReservedInstancesOffering.ReadOnly =
    zio.aws.ec2.model.ReservedInstancesOffering.wrap(buildAwsValue())
}
object ReservedInstancesOffering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReservedInstancesOffering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReservedInstancesOffering =
      zio.aws.ec2.model.ReservedInstancesOffering(
        availabilityZone.map(value => value),
        duration.map(value => value),
        fixedPrice.map(value => value),
        instanceType.map(value => value),
        productDescription.map(value => value),
        reservedInstancesOfferingId.map(value => value),
        usagePrice.map(value => value),
        currencyCode.map(value => value),
        instanceTenancy.map(value => value),
        marketplace.map(value => value),
        offeringClass.map(value => value),
        offeringType.map(value => value),
        pricingDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scope.map(value => value)
      )
    def availabilityZone: Option[String]
    def duration: Option[Long]
    def fixedPrice: Option[Float]
    def instanceType: Option[zio.aws.ec2.model.InstanceType]
    def productDescription: Option[zio.aws.ec2.model.RIProductDescription]
    def reservedInstancesOfferingId: Option[String]
    def usagePrice: Option[Float]
    def currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues]
    def instanceTenancy: Option[zio.aws.ec2.model.Tenancy]
    def marketplace: Option[Boolean]
    def offeringClass: Option[zio.aws.ec2.model.OfferingClassType]
    def offeringType: Option[zio.aws.ec2.model.OfferingTypeValues]
    def pricingDetails: Option[List[zio.aws.ec2.model.PricingDetail.ReadOnly]]
    def recurringCharges
        : Option[List[zio.aws.ec2.model.RecurringCharge.ReadOnly]]
    def scope: Option[zio.aws.ec2.model.Scope]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getDuration: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("duration", duration)
    def getFixedPrice: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getProductDescription
        : ZIO[Any, AwsError, zio.aws.ec2.model.RIProductDescription] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getReservedInstancesOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedInstancesOfferingId",
        reservedInstancesOfferingId
      )
    def getUsagePrice: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
    def getCurrencyCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.CurrencyCodeValues] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getInstanceTenancy: ZIO[Any, AwsError, zio.aws.ec2.model.Tenancy] =
      AwsError.unwrapOptionField("instanceTenancy", instanceTenancy)
    def getMarketplace: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("marketplace", marketplace)
    def getOfferingClass
        : ZIO[Any, AwsError, zio.aws.ec2.model.OfferingClassType] =
      AwsError.unwrapOptionField("offeringClass", offeringClass)
    def getOfferingType
        : ZIO[Any, AwsError, zio.aws.ec2.model.OfferingTypeValues] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getPricingDetails
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PricingDetail.ReadOnly]] =
      AwsError.unwrapOptionField("pricingDetails", pricingDetails)
    def getRecurringCharges
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.RecurringCharge.ReadOnly]] =
      AwsError.unwrapOptionField("recurringCharges", recurringCharges)
    def getScope: ZIO[Any, AwsError, zio.aws.ec2.model.Scope] =
      AwsError.unwrapOptionField("scope", scope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstancesOffering
  ) extends zio.aws.ec2.model.ReservedInstancesOffering.ReadOnly {
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val duration: Option[Long] =
      scala.Option(impl.duration()).map(value => value: Long)
    override val fixedPrice: Option[Float] =
      scala.Option(impl.fixedPrice()).map(value => value: Float)
    override val instanceType: Option[zio.aws.ec2.model.InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val productDescription
        : Option[zio.aws.ec2.model.RIProductDescription] = scala
      .Option(impl.productDescription())
      .map(value => zio.aws.ec2.model.RIProductDescription.wrap(value))
    override val reservedInstancesOfferingId: Option[String] = scala
      .Option(impl.reservedInstancesOfferingId())
      .map(value => value: String)
    override val usagePrice: Option[Float] =
      scala.Option(impl.usagePrice()).map(value => value: Float)
    override val currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues] =
      scala
        .Option(impl.currencyCode())
        .map(value => zio.aws.ec2.model.CurrencyCodeValues.wrap(value))
    override val instanceTenancy: Option[zio.aws.ec2.model.Tenancy] = scala
      .Option(impl.instanceTenancy())
      .map(value => zio.aws.ec2.model.Tenancy.wrap(value))
    override val marketplace: Option[Boolean] =
      scala.Option(impl.marketplace()).map(value => value: Boolean)
    override val offeringClass: Option[zio.aws.ec2.model.OfferingClassType] =
      scala
        .Option(impl.offeringClass())
        .map(value => zio.aws.ec2.model.OfferingClassType.wrap(value))
    override val offeringType: Option[zio.aws.ec2.model.OfferingTypeValues] =
      scala
        .Option(impl.offeringType())
        .map(value => zio.aws.ec2.model.OfferingTypeValues.wrap(value))
    override val pricingDetails
        : Option[List[zio.aws.ec2.model.PricingDetail.ReadOnly]] = scala
      .Option(impl.pricingDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.PricingDetail.wrap(item)
        }.toList
      )
    override val recurringCharges
        : Option[List[zio.aws.ec2.model.RecurringCharge.ReadOnly]] = scala
      .Option(impl.recurringCharges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.RecurringCharge.wrap(item)
        }.toList
      )
    override val scope: Option[zio.aws.ec2.model.Scope] = scala
      .Option(impl.scope())
      .map(value => zio.aws.ec2.model.Scope.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstancesOffering
  ): zio.aws.ec2.model.ReservedInstancesOffering.ReadOnly = new Wrapper(impl)
}
