package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProvisionByoipCidrResponse(
    byoipCidr: Option[zio.aws.ec2.model.ByoipCidr] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrResponse = {
    import ProvisionByoipCidrResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrResponse
      .builder()
      .optionallyWith(byoipCidr.map(value => value.buildAwsValue()))(
        _.byoipCidr
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ProvisionByoipCidrResponse.ReadOnly =
    zio.aws.ec2.model.ProvisionByoipCidrResponse.wrap(buildAwsValue())
}
object ProvisionByoipCidrResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ProvisionByoipCidrResponse =
      zio.aws.ec2.model
        .ProvisionByoipCidrResponse(byoipCidr.map(value => value.asEditable))
    def byoipCidr: Option[zio.aws.ec2.model.ByoipCidr.ReadOnly]
    def getByoipCidr: ZIO[Any, AwsError, zio.aws.ec2.model.ByoipCidr.ReadOnly] =
      AwsError.unwrapOptionField("byoipCidr", byoipCidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrResponse
  ) extends zio.aws.ec2.model.ProvisionByoipCidrResponse.ReadOnly {
    override val byoipCidr: Option[zio.aws.ec2.model.ByoipCidr.ReadOnly] = scala
      .Option(impl.byoipCidr())
      .map(value => zio.aws.ec2.model.ByoipCidr.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrResponse
  ): zio.aws.ec2.model.ProvisionByoipCidrResponse.ReadOnly = new Wrapper(impl)
}
