package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  MillisecondDateTime,
  Integer,
  IpAddress,
  NetworkInsightsPathId,
  ResourceArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class NetworkInsightsPath(
    networkInsightsPathId: Option[NetworkInsightsPathId] = None,
    networkInsightsPathArn: Option[ResourceArn] = None,
    createdDate: Option[MillisecondDateTime] = None,
    source: Option[String] = None,
    destination: Option[String] = None,
    sourceIp: Option[IpAddress] = None,
    destinationIp: Option[IpAddress] = None,
    protocol: Option[zio.aws.ec2.model.Protocol] = None,
    destinationPort: Option[Integer] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInsightsPath = {
    import NetworkInsightsPath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInsightsPath
      .builder()
      .optionallyWith(
        networkInsightsPathId.map(value =>
          NetworkInsightsPathId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsPathId)
      .optionallyWith(
        networkInsightsPathArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.networkInsightsPathArn)
      .optionallyWith(
        createdDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(destination.map(value => value: java.lang.String))(
        _.destination
      )
      .optionallyWith(
        sourceIp.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.sourceIp)
      .optionallyWith(
        destinationIp.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.destinationIp)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        destinationPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.destinationPort)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInsightsPath.ReadOnly =
    zio.aws.ec2.model.NetworkInsightsPath.wrap(buildAwsValue())
}
object NetworkInsightsPath {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInsightsPath
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInsightsPath =
      zio.aws.ec2.model.NetworkInsightsPath(
        networkInsightsPathId.map(value => value),
        networkInsightsPathArn.map(value => value),
        createdDate.map(value => value),
        source.map(value => value),
        destination.map(value => value),
        sourceIp.map(value => value),
        destinationIp.map(value => value),
        protocol.map(value => value),
        destinationPort.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def networkInsightsPathId: Option[NetworkInsightsPathId]
    def networkInsightsPathArn: Option[ResourceArn]
    def createdDate: Option[MillisecondDateTime]
    def source: Option[String]
    def destination: Option[String]
    def sourceIp: Option[IpAddress]
    def destinationIp: Option[IpAddress]
    def protocol: Option[zio.aws.ec2.model.Protocol]
    def destinationPort: Option[Integer]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getNetworkInsightsPathId: ZIO[Any, AwsError, NetworkInsightsPathId] =
      AwsError.unwrapOptionField("networkInsightsPathId", networkInsightsPathId)
    def getNetworkInsightsPathArn: ZIO[Any, AwsError, ResourceArn] = AwsError
      .unwrapOptionField("networkInsightsPathArn", networkInsightsPathArn)
    def getCreatedDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getDestination: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destination", destination)
    def getSourceIp: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("sourceIp", sourceIp)
    def getDestinationIp: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("destinationIp", destinationIp)
    def getProtocol: ZIO[Any, AwsError, zio.aws.ec2.model.Protocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getDestinationPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("destinationPort", destinationPort)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInsightsPath
  ) extends zio.aws.ec2.model.NetworkInsightsPath.ReadOnly {
    override val networkInsightsPathId: Option[NetworkInsightsPathId] = scala
      .Option(impl.networkInsightsPathId())
      .map(value => zio.aws.ec2.model.primitives.NetworkInsightsPathId(value))
    override val networkInsightsPathArn: Option[ResourceArn] = scala
      .Option(impl.networkInsightsPathArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val createdDate: Option[MillisecondDateTime] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val source: Option[String] =
      scala.Option(impl.source()).map(value => value: String)
    override val destination: Option[String] =
      scala.Option(impl.destination()).map(value => value: String)
    override val sourceIp: Option[IpAddress] = scala
      .Option(impl.sourceIp())
      .map(value => zio.aws.ec2.model.primitives.IpAddress(value))
    override val destinationIp: Option[IpAddress] = scala
      .Option(impl.destinationIp())
      .map(value => zio.aws.ec2.model.primitives.IpAddress(value))
    override val protocol: Option[zio.aws.ec2.model.Protocol] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.ec2.model.Protocol.wrap(value))
    override val destinationPort: Option[Integer] = scala
      .Option(impl.destinationPort())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInsightsPath
  ): zio.aws.ec2.model.NetworkInsightsPath.ReadOnly = new Wrapper(impl)
}
