package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  MillisecondDateTime,
  NetworkInsightsPathId,
  ResourceArn,
  NetworkInsightsAnalysisId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class NetworkInsightsAnalysis(
    networkInsightsAnalysisId: Option[NetworkInsightsAnalysisId] = None,
    networkInsightsAnalysisArn: Option[ResourceArn] = None,
    networkInsightsPathId: Option[NetworkInsightsPathId] = None,
    filterInArns: Option[Iterable[ResourceArn]] = None,
    startDate: Option[MillisecondDateTime] = None,
    status: Option[zio.aws.ec2.model.AnalysisStatus] = None,
    statusMessage: Option[String] = None,
    warningMessage: Option[String] = None,
    networkPathFound: Option[Boolean] = None,
    forwardPathComponents: Option[Iterable[zio.aws.ec2.model.PathComponent]] =
      None,
    returnPathComponents: Option[Iterable[zio.aws.ec2.model.PathComponent]] =
      None,
    explanations: Option[Iterable[zio.aws.ec2.model.Explanation]] = None,
    alternatePathHints: Option[Iterable[zio.aws.ec2.model.AlternatePathHint]] =
      None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInsightsAnalysis = {
    import NetworkInsightsAnalysis.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInsightsAnalysis
      .builder()
      .optionallyWith(
        networkInsightsAnalysisId.map(value =>
          NetworkInsightsAnalysisId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAnalysisId)
      .optionallyWith(
        networkInsightsAnalysisArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAnalysisArn)
      .optionallyWith(
        networkInsightsPathId.map(value =>
          NetworkInsightsPathId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsPathId)
      .optionallyWith(
        filterInArns.map(value =>
          value.map { item =>
            ResourceArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.filterInArns)
      .optionallyWith(
        startDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.startDate)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(warningMessage.map(value => value: java.lang.String))(
        _.warningMessage
      )
      .optionallyWith(networkPathFound.map(value => value: java.lang.Boolean))(
        _.networkPathFound
      )
      .optionallyWith(
        forwardPathComponents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.forwardPathComponents)
      .optionallyWith(
        returnPathComponents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.returnPathComponents)
      .optionallyWith(
        explanations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.explanations)
      .optionallyWith(
        alternatePathHints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alternatePathHints)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInsightsAnalysis.ReadOnly =
    zio.aws.ec2.model.NetworkInsightsAnalysis.wrap(buildAwsValue())
}
object NetworkInsightsAnalysis {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInsightsAnalysis
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInsightsAnalysis =
      zio.aws.ec2.model.NetworkInsightsAnalysis(
        networkInsightsAnalysisId.map(value => value),
        networkInsightsAnalysisArn.map(value => value),
        networkInsightsPathId.map(value => value),
        filterInArns.map(value => value),
        startDate.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        warningMessage.map(value => value),
        networkPathFound.map(value => value),
        forwardPathComponents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        returnPathComponents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        explanations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        alternatePathHints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def networkInsightsAnalysisId: Option[NetworkInsightsAnalysisId]
    def networkInsightsAnalysisArn: Option[ResourceArn]
    def networkInsightsPathId: Option[NetworkInsightsPathId]
    def filterInArns: Option[List[ResourceArn]]
    def startDate: Option[MillisecondDateTime]
    def status: Option[zio.aws.ec2.model.AnalysisStatus]
    def statusMessage: Option[String]
    def warningMessage: Option[String]
    def networkPathFound: Option[Boolean]
    def forwardPathComponents
        : Option[List[zio.aws.ec2.model.PathComponent.ReadOnly]]
    def returnPathComponents
        : Option[List[zio.aws.ec2.model.PathComponent.ReadOnly]]
    def explanations: Option[List[zio.aws.ec2.model.Explanation.ReadOnly]]
    def alternatePathHints
        : Option[List[zio.aws.ec2.model.AlternatePathHint.ReadOnly]]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getNetworkInsightsAnalysisId
        : ZIO[Any, AwsError, NetworkInsightsAnalysisId] = AwsError
      .unwrapOptionField("networkInsightsAnalysisId", networkInsightsAnalysisId)
    def getNetworkInsightsAnalysisArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField(
        "networkInsightsAnalysisArn",
        networkInsightsAnalysisArn
      )
    def getNetworkInsightsPathId: ZIO[Any, AwsError, NetworkInsightsPathId] =
      AwsError.unwrapOptionField("networkInsightsPathId", networkInsightsPathId)
    def getFilterInArns: ZIO[Any, AwsError, List[ResourceArn]] =
      AwsError.unwrapOptionField("filterInArns", filterInArns)
    def getStartDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getStatus: ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getWarningMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("warningMessage", warningMessage)
    def getNetworkPathFound: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("networkPathFound", networkPathFound)
    def getForwardPathComponents
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PathComponent.ReadOnly]] =
      AwsError.unwrapOptionField("forwardPathComponents", forwardPathComponents)
    def getReturnPathComponents
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PathComponent.ReadOnly]] =
      AwsError.unwrapOptionField("returnPathComponents", returnPathComponents)
    def getExplanations
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Explanation.ReadOnly]] =
      AwsError.unwrapOptionField("explanations", explanations)
    def getAlternatePathHints: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AlternatePathHint.ReadOnly
    ]] = AwsError.unwrapOptionField("alternatePathHints", alternatePathHints)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInsightsAnalysis
  ) extends zio.aws.ec2.model.NetworkInsightsAnalysis.ReadOnly {
    override val networkInsightsAnalysisId: Option[NetworkInsightsAnalysisId] =
      scala
        .Option(impl.networkInsightsAnalysisId())
        .map(value =>
          zio.aws.ec2.model.primitives.NetworkInsightsAnalysisId(value)
        )
    override val networkInsightsAnalysisArn: Option[ResourceArn] = scala
      .Option(impl.networkInsightsAnalysisArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val networkInsightsPathId: Option[NetworkInsightsPathId] = scala
      .Option(impl.networkInsightsPathId())
      .map(value => zio.aws.ec2.model.primitives.NetworkInsightsPathId(value))
    override val filterInArns: Option[List[ResourceArn]] = scala
      .Option(impl.filterInArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.ResourceArn(item)
        }.toList
      )
    override val startDate: Option[MillisecondDateTime] = scala
      .Option(impl.startDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val status: Option[zio.aws.ec2.model.AnalysisStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ec2.model.AnalysisStatus.wrap(value))
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val warningMessage: Option[String] =
      scala.Option(impl.warningMessage()).map(value => value: String)
    override val networkPathFound: Option[Boolean] =
      scala.Option(impl.networkPathFound()).map(value => value: Boolean)
    override val forwardPathComponents
        : Option[List[zio.aws.ec2.model.PathComponent.ReadOnly]] = scala
      .Option(impl.forwardPathComponents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.PathComponent.wrap(item)
        }.toList
      )
    override val returnPathComponents
        : Option[List[zio.aws.ec2.model.PathComponent.ReadOnly]] = scala
      .Option(impl.returnPathComponents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.PathComponent.wrap(item)
        }.toList
      )
    override val explanations
        : Option[List[zio.aws.ec2.model.Explanation.ReadOnly]] = scala
      .Option(impl.explanations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Explanation.wrap(item)
        }.toList
      )
    override val alternatePathHints
        : Option[List[zio.aws.ec2.model.AlternatePathHint.ReadOnly]] = scala
      .Option(impl.alternatePathHints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AlternatePathHint.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInsightsAnalysis
  ): zio.aws.ec2.model.NetworkInsightsAnalysis.ReadOnly = new Wrapper(impl)
}
