package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamPoolId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MoveByoipCidrToIpamRequest(
    cidr: Option[String] = None,
    ipamPoolId: Option[IpamPoolId] = None,
    ipamPoolOwner: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.MoveByoipCidrToIpamRequest = {
    import MoveByoipCidrToIpamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.MoveByoipCidrToIpamRequest
      .builder()
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .optionallyWith(
        ipamPoolId.map(value => IpamPoolId.unwrap(value): java.lang.String)
      )(_.ipamPoolId)
      .optionallyWith(ipamPoolOwner.map(value => value: java.lang.String))(
        _.ipamPoolOwner
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.MoveByoipCidrToIpamRequest.ReadOnly =
    zio.aws.ec2.model.MoveByoipCidrToIpamRequest.wrap(buildAwsValue())
}
object MoveByoipCidrToIpamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.MoveByoipCidrToIpamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.MoveByoipCidrToIpamRequest =
      zio.aws.ec2.model.MoveByoipCidrToIpamRequest(
        cidr.map(value => value),
        ipamPoolId.map(value => value),
        ipamPoolOwner.map(value => value)
      )
    def cidr: Option[String]
    def ipamPoolId: Option[IpamPoolId]
    def ipamPoolOwner: Option[String]
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getIpamPoolId: ZIO[Any, AwsError, IpamPoolId] =
      AwsError.unwrapOptionField("ipamPoolId", ipamPoolId)
    def getIpamPoolOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipamPoolOwner", ipamPoolOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.MoveByoipCidrToIpamRequest
  ) extends zio.aws.ec2.model.MoveByoipCidrToIpamRequest.ReadOnly {
    override val cidr: Option[String] =
      scala.Option(impl.cidr()).map(value => value: String)
    override val ipamPoolId: Option[IpamPoolId] = scala
      .Option(impl.ipamPoolId())
      .map(value => zio.aws.ec2.model.primitives.IpamPoolId(value))
    override val ipamPoolOwner: Option[String] =
      scala.Option(impl.ipamPoolOwner()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.MoveByoipCidrToIpamRequest
  ): zio.aws.ec2.model.MoveByoipCidrToIpamRequest.ReadOnly = new Wrapper(impl)
}
