package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HibernationOptions(configured: Option[Boolean] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.HibernationOptions = {
    import HibernationOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.HibernationOptions
      .builder()
      .optionallyWith(configured.map(value => value: java.lang.Boolean))(
        _.configured
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.HibernationOptions.ReadOnly =
    zio.aws.ec2.model.HibernationOptions.wrap(buildAwsValue())
}
object HibernationOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.HibernationOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.HibernationOptions =
      zio.aws.ec2.model.HibernationOptions(configured.map(value => value))
    def configured: Option[Boolean]
    def getConfigured: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("configured", configured)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.HibernationOptions
  ) extends zio.aws.ec2.model.HibernationOptions.ReadOnly {
    override val configured: Option[Boolean] =
      scala.Option(impl.configured()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.HibernationOptions
  ): zio.aws.ec2.model.HibernationOptions.ReadOnly = new Wrapper(impl)
}
