package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GroupIdentifier(
    groupName: Option[String] = None,
    groupId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GroupIdentifier = {
    import GroupIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GroupIdentifier
      .builder()
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(groupId.map(value => value: java.lang.String))(_.groupId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GroupIdentifier.ReadOnly =
    zio.aws.ec2.model.GroupIdentifier.wrap(buildAwsValue())
}
object GroupIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GroupIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GroupIdentifier =
      zio.aws.ec2.model.GroupIdentifier(
        groupName.map(value => value),
        groupId.map(value => value)
      )
    def groupName: Option[String]
    def groupId: Option[String]
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupId", groupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GroupIdentifier
  ) extends zio.aws.ec2.model.GroupIdentifier.ReadOnly {
    override val groupName: Option[String] =
      scala.Option(impl.groupName()).map(value => value: String)
    override val groupId: Option[String] =
      scala.Option(impl.groupId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GroupIdentifier
  ): zio.aws.ec2.model.GroupIdentifier.ReadOnly = new Wrapper(impl)
}
