package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcFlowLogId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetFlowLogsIntegrationTemplateRequest(
    flowLogId: VpcFlowLogId,
    configDeliveryS3DestinationArn: String,
    integrateServices: zio.aws.ec2.model.IntegrateServices
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetFlowLogsIntegrationTemplateRequest = {
    import GetFlowLogsIntegrationTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetFlowLogsIntegrationTemplateRequest
      .builder()
      .flowLogId(VpcFlowLogId.unwrap(flowLogId): java.lang.String)
      .configDeliveryS3DestinationArn(
        configDeliveryS3DestinationArn: java.lang.String
      )
      .integrateServices(integrateServices.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetFlowLogsIntegrationTemplateRequest.ReadOnly =
    zio.aws.ec2.model.GetFlowLogsIntegrationTemplateRequest
      .wrap(buildAwsValue())
}
object GetFlowLogsIntegrationTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetFlowLogsIntegrationTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetFlowLogsIntegrationTemplateRequest =
      zio.aws.ec2.model.GetFlowLogsIntegrationTemplateRequest(
        flowLogId,
        configDeliveryS3DestinationArn,
        integrateServices.asEditable
      )
    def flowLogId: VpcFlowLogId
    def configDeliveryS3DestinationArn: String
    def integrateServices: zio.aws.ec2.model.IntegrateServices.ReadOnly
    def getFlowLogId: ZIO[Any, Nothing, VpcFlowLogId] = ZIO.succeed(flowLogId)
    def getConfigDeliveryS3DestinationArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(configDeliveryS3DestinationArn)
    def getIntegrateServices
        : ZIO[Any, Nothing, zio.aws.ec2.model.IntegrateServices.ReadOnly] =
      ZIO.succeed(integrateServices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetFlowLogsIntegrationTemplateRequest
  ) extends zio.aws.ec2.model.GetFlowLogsIntegrationTemplateRequest.ReadOnly {
    override val flowLogId: VpcFlowLogId =
      zio.aws.ec2.model.primitives.VpcFlowLogId(impl.flowLogId())
    override val configDeliveryS3DestinationArn: String =
      impl.configDeliveryS3DestinationArn(): String
    override val integrateServices
        : zio.aws.ec2.model.IntegrateServices.ReadOnly =
      zio.aws.ec2.model.IntegrateServices.wrap(impl.integrateServices())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetFlowLogsIntegrationTemplateRequest
  ): zio.aws.ec2.model.GetFlowLogsIntegrationTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
