package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetAssociatedIpv6PoolCidrsResponse(
    ipv6CidrAssociations: Option[
      Iterable[zio.aws.ec2.model.Ipv6CidrAssociation]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsResponse = {
    import GetAssociatedIpv6PoolCidrsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsResponse
      .builder()
      .optionallyWith(
        ipv6CidrAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6CidrAssociations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsResponse.ReadOnly =
    zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsResponse.wrap(buildAwsValue())
}
object GetAssociatedIpv6PoolCidrsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsResponse =
      zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsResponse(
        ipv6CidrAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def ipv6CidrAssociations
        : Option[List[zio.aws.ec2.model.Ipv6CidrAssociation.ReadOnly]]
    def nextToken: Option[String]
    def getIpv6CidrAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Ipv6CidrAssociation.ReadOnly
    ]] =
      AwsError.unwrapOptionField("ipv6CidrAssociations", ipv6CidrAssociations)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsResponse
  ) extends zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsResponse.ReadOnly {
    override val ipv6CidrAssociations
        : Option[List[zio.aws.ec2.model.Ipv6CidrAssociation.ReadOnly]] = scala
      .Option(impl.ipv6CidrAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Ipv6CidrAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsResponse
  ): zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsResponse.ReadOnly =
    new Wrapper(impl)
}
