package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitGatewayAttachmentId,
  TransitGatewayRouteTableId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnableTransitGatewayRouteTablePropagationRequest(
    transitGatewayRouteTableId: TransitGatewayRouteTableId,
    transitGatewayAttachmentId: TransitGatewayAttachmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationRequest = {
    import EnableTransitGatewayRouteTablePropagationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationRequest
      .builder()
      .transitGatewayRouteTableId(
        TransitGatewayRouteTableId.unwrap(
          transitGatewayRouteTableId
        ): java.lang.String
      )
      .transitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transitGatewayAttachmentId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationRequest.ReadOnly =
    zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationRequest
      .wrap(buildAwsValue())
}
object EnableTransitGatewayRouteTablePropagationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationRequest =
      zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationRequest(
        transitGatewayRouteTableId,
        transitGatewayAttachmentId
      )
    def transitGatewayRouteTableId: TransitGatewayRouteTableId
    def transitGatewayAttachmentId: TransitGatewayAttachmentId
    def getTransitGatewayRouteTableId
        : ZIO[Any, Nothing, TransitGatewayRouteTableId] =
      ZIO.succeed(transitGatewayRouteTableId)
    def getTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transitGatewayAttachmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationRequest
  ) extends zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationRequest.ReadOnly {
    override val transitGatewayRouteTableId: TransitGatewayRouteTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayRouteTableId(impl.transitGatewayRouteTableId())
    override val transitGatewayAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.transitGatewayAttachmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationRequest
  ): zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationRequest.ReadOnly =
    new Wrapper(impl)
}
