package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SubnetCidrAssociationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateSubnetCidrBlockRequest(
    associationId: SubnetCidrAssociationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateSubnetCidrBlockRequest = {
    import DisassociateSubnetCidrBlockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateSubnetCidrBlockRequest
      .builder()
      .associationId(
        SubnetCidrAssociationId.unwrap(associationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateSubnetCidrBlockRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateSubnetCidrBlockRequest.wrap(buildAwsValue())
}
object DisassociateSubnetCidrBlockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateSubnetCidrBlockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisassociateSubnetCidrBlockRequest =
      zio.aws.ec2.model.DisassociateSubnetCidrBlockRequest(associationId)
    def associationId: SubnetCidrAssociationId
    def getAssociationId: ZIO[Any, Nothing, SubnetCidrAssociationId] =
      ZIO.succeed(associationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateSubnetCidrBlockRequest
  ) extends zio.aws.ec2.model.DisassociateSubnetCidrBlockRequest.ReadOnly {
    override val associationId: SubnetCidrAssociationId =
      zio.aws.ec2.model.primitives.SubnetCidrAssociationId(impl.associationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateSubnetCidrBlockRequest
  ): zio.aws.ec2.model.DisassociateSubnetCidrBlockRequest.ReadOnly =
    new Wrapper(impl)
}
