package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ImageId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisableImageDeprecationRequest(imageId: ImageId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableImageDeprecationRequest = {
    import DisableImageDeprecationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableImageDeprecationRequest
      .builder()
      .imageId(ImageId.unwrap(imageId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DisableImageDeprecationRequest.ReadOnly =
    zio.aws.ec2.model.DisableImageDeprecationRequest.wrap(buildAwsValue())
}
object DisableImageDeprecationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableImageDeprecationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisableImageDeprecationRequest =
      zio.aws.ec2.model.DisableImageDeprecationRequest(imageId)
    def imageId: ImageId
    def getImageId: ZIO[Any, Nothing, ImageId] = ZIO.succeed(imageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableImageDeprecationRequest
  ) extends zio.aws.ec2.model.DisableImageDeprecationRequest.ReadOnly {
    override val imageId: ImageId =
      zio.aws.ec2.model.primitives.ImageId(impl.imageId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableImageDeprecationRequest
  ): zio.aws.ec2.model.DisableImageDeprecationRequest.ReadOnly = new Wrapper(
    impl
  )
}
