package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SnapshotId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisableFastSnapshotRestoresRequest(
    availabilityZones: Iterable[String],
    sourceSnapshotIds: Iterable[SnapshotId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresRequest = {
    import DisableFastSnapshotRestoresRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresRequest
      .builder()
      .availabilityZones(availabilityZones.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .sourceSnapshotIds(sourceSnapshotIds.map { item =>
        SnapshotId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisableFastSnapshotRestoresRequest.ReadOnly =
    zio.aws.ec2.model.DisableFastSnapshotRestoresRequest.wrap(buildAwsValue())
}
object DisableFastSnapshotRestoresRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisableFastSnapshotRestoresRequest =
      zio.aws.ec2.model.DisableFastSnapshotRestoresRequest(
        availabilityZones,
        sourceSnapshotIds
      )
    def availabilityZones: List[String]
    def sourceSnapshotIds: List[SnapshotId]
    def getAvailabilityZones: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(availabilityZones)
    def getSourceSnapshotIds: ZIO[Any, Nothing, List[SnapshotId]] =
      ZIO.succeed(sourceSnapshotIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresRequest
  ) extends zio.aws.ec2.model.DisableFastSnapshotRestoresRequest.ReadOnly {
    override val availabilityZones: List[String] = impl
      .availabilityZones()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val sourceSnapshotIds: List[SnapshotId] = impl
      .sourceSnapshotIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.SnapshotId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresRequest
  ): zio.aws.ec2.model.DisableFastSnapshotRestoresRequest.ReadOnly =
    new Wrapper(impl)
}
