package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpnConnectionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVpnConnectionsRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    vpnConnectionIds: Option[Iterable[VpnConnectionId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest = {
    import DescribeVpnConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        vpnConnectionIds.map(value =>
          value.map { item =>
            VpnConnectionId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.vpnConnectionIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVpnConnectionsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVpnConnectionsRequest.wrap(buildAwsValue())
}
object DescribeVpnConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpnConnectionsRequest =
      zio.aws.ec2.model.DescribeVpnConnectionsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpnConnectionIds.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def vpnConnectionIds: Option[List[VpnConnectionId]]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getVpnConnectionIds: ZIO[Any, AwsError, List[VpnConnectionId]] =
      AwsError.unwrapOptionField("vpnConnectionIds", vpnConnectionIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest
  ) extends zio.aws.ec2.model.DescribeVpnConnectionsRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val vpnConnectionIds: Option[List[VpnConnectionId]] = scala
      .Option(impl.vpnConnectionIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.VpnConnectionId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest
  ): zio.aws.ec2.model.DescribeVpnConnectionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
