package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVpcPeeringConnectionsResponse(
    vpcPeeringConnections: Option[
      Iterable[zio.aws.ec2.model.VpcPeeringConnection]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsResponse = {
    import DescribeVpcPeeringConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsResponse
      .builder()
      .optionallyWith(
        vpcPeeringConnections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcPeeringConnections)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVpcPeeringConnectionsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVpcPeeringConnectionsResponse
      .wrap(buildAwsValue())
}
object DescribeVpcPeeringConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpcPeeringConnectionsResponse =
      zio.aws.ec2.model.DescribeVpcPeeringConnectionsResponse(
        vpcPeeringConnections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def vpcPeeringConnections
        : Option[List[zio.aws.ec2.model.VpcPeeringConnection.ReadOnly]]
    def nextToken: Option[String]
    def getVpcPeeringConnections: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VpcPeeringConnection.ReadOnly
    ]] =
      AwsError.unwrapOptionField("vpcPeeringConnections", vpcPeeringConnections)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsResponse
  ) extends zio.aws.ec2.model.DescribeVpcPeeringConnectionsResponse.ReadOnly {
    override val vpcPeeringConnections
        : Option[List[zio.aws.ec2.model.VpcPeeringConnection.ReadOnly]] = scala
      .Option(impl.vpcPeeringConnections())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VpcPeeringConnection.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsResponse
  ): zio.aws.ec2.model.DescribeVpcPeeringConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
