package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSnapshotAttributeResponse(
    createVolumePermissions: Option[
      Iterable[zio.aws.ec2.model.CreateVolumePermission]
    ] = None,
    productCodes: Option[Iterable[zio.aws.ec2.model.ProductCode]] = None,
    snapshotId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeResponse = {
    import DescribeSnapshotAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeResponse
      .builder()
      .optionallyWith(
        createVolumePermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.createVolumePermissions)
      .optionallyWith(
        productCodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productCodes)
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSnapshotAttributeResponse.ReadOnly =
    zio.aws.ec2.model.DescribeSnapshotAttributeResponse.wrap(buildAwsValue())
}
object DescribeSnapshotAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSnapshotAttributeResponse =
      zio.aws.ec2.model.DescribeSnapshotAttributeResponse(
        createVolumePermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        productCodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        snapshotId.map(value => value)
      )
    def createVolumePermissions
        : Option[List[zio.aws.ec2.model.CreateVolumePermission.ReadOnly]]
    def productCodes: Option[List[zio.aws.ec2.model.ProductCode.ReadOnly]]
    def snapshotId: Option[String]
    def getCreateVolumePermissions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.CreateVolumePermission.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "createVolumePermissions",
      createVolumePermissions
    )
    def getProductCodes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      AwsError.unwrapOptionField("productCodes", productCodes)
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeResponse
  ) extends zio.aws.ec2.model.DescribeSnapshotAttributeResponse.ReadOnly {
    override val createVolumePermissions
        : Option[List[zio.aws.ec2.model.CreateVolumePermission.ReadOnly]] =
      scala
        .Option(impl.createVolumePermissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.CreateVolumePermission.wrap(item)
          }.toList
        )
    override val productCodes
        : Option[List[zio.aws.ec2.model.ProductCode.ReadOnly]] = scala
      .Option(impl.productCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ProductCode.wrap(item)
        }.toList
      )
    override val snapshotId: Option[String] =
      scala.Option(impl.snapshotId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeResponse
  ): zio.aws.ec2.model.DescribeSnapshotAttributeResponse.ReadOnly = new Wrapper(
    impl
  )
}
