package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInstanceStatusResponse(
    instanceStatuses: Option[Iterable[zio.aws.ec2.model.InstanceStatus]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse = {
    import DescribeInstanceStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse
      .builder()
      .optionallyWith(
        instanceStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceStatuses)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeInstanceStatusResponse.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceStatusResponse.wrap(buildAwsValue())
}
object DescribeInstanceStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInstanceStatusResponse =
      zio.aws.ec2.model.DescribeInstanceStatusResponse(
        instanceStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instanceStatuses
        : Option[List[zio.aws.ec2.model.InstanceStatus.ReadOnly]]
    def nextToken: Option[String]
    def getInstanceStatuses
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.InstanceStatus.ReadOnly]] =
      AwsError.unwrapOptionField("instanceStatuses", instanceStatuses)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse
  ) extends zio.aws.ec2.model.DescribeInstanceStatusResponse.ReadOnly {
    override val instanceStatuses
        : Option[List[zio.aws.ec2.model.InstanceStatus.ReadOnly]] = scala
      .Option(impl.instanceStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceStatus.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse
  ): zio.aws.ec2.model.DescribeInstanceStatusResponse.ReadOnly = new Wrapper(
    impl
  )
}
