package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeImportImageTasksResponse(
    importImageTasks: Option[Iterable[zio.aws.ec2.model.ImportImageTask]] =
      None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse = {
    import DescribeImportImageTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse
      .builder()
      .optionallyWith(
        importImageTasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.importImageTasks)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeImportImageTasksResponse.ReadOnly =
    zio.aws.ec2.model.DescribeImportImageTasksResponse.wrap(buildAwsValue())
}
object DescribeImportImageTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeImportImageTasksResponse =
      zio.aws.ec2.model.DescribeImportImageTasksResponse(
        importImageTasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def importImageTasks
        : Option[List[zio.aws.ec2.model.ImportImageTask.ReadOnly]]
    def nextToken: Option[String]
    def getImportImageTasks
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ImportImageTask.ReadOnly]] =
      AwsError.unwrapOptionField("importImageTasks", importImageTasks)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse
  ) extends zio.aws.ec2.model.DescribeImportImageTasksResponse.ReadOnly {
    override val importImageTasks
        : Option[List[zio.aws.ec2.model.ImportImageTask.ReadOnly]] = scala
      .Option(impl.importImageTasks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ImportImageTask.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse
  ): zio.aws.ec2.model.DescribeImportImageTasksResponse.ReadOnly = new Wrapper(
    impl
  )
}
