package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteTrafficMirrorSessionResponse(
    trafficMirrorSessionId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionResponse = {
    import DeleteTrafficMirrorSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionResponse
      .builder()
      .optionallyWith(
        trafficMirrorSessionId.map(value => value: java.lang.String)
      )(_.trafficMirrorSessionId)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTrafficMirrorSessionResponse.ReadOnly =
    zio.aws.ec2.model.DeleteTrafficMirrorSessionResponse.wrap(buildAwsValue())
}
object DeleteTrafficMirrorSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTrafficMirrorSessionResponse =
      zio.aws.ec2.model.DeleteTrafficMirrorSessionResponse(
        trafficMirrorSessionId.map(value => value)
      )
    def trafficMirrorSessionId: Option[String]
    def getTrafficMirrorSessionId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("trafficMirrorSessionId", trafficMirrorSessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionResponse
  ) extends zio.aws.ec2.model.DeleteTrafficMirrorSessionResponse.ReadOnly {
    override val trafficMirrorSessionId: Option[String] =
      scala.Option(impl.trafficMirrorSessionId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionResponse
  ): zio.aws.ec2.model.DeleteTrafficMirrorSessionResponse.ReadOnly =
    new Wrapper(impl)
}
