package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpcId, SecurityGroupId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClientVpnEndpoint(
    clientVpnEndpointId: Option[String] = None,
    description: Option[String] = None,
    status: Option[zio.aws.ec2.model.ClientVpnEndpointStatus] = None,
    creationTime: Option[String] = None,
    deletionTime: Option[String] = None,
    dnsName: Option[String] = None,
    clientCidrBlock: Option[String] = None,
    dnsServers: Option[Iterable[String]] = None,
    splitTunnel: Option[Boolean] = None,
    vpnProtocol: Option[zio.aws.ec2.model.VpnProtocol] = None,
    transportProtocol: Option[zio.aws.ec2.model.TransportProtocol] = None,
    vpnPort: Option[Integer] = None,
    associatedTargetNetworks: Option[
      Iterable[zio.aws.ec2.model.AssociatedTargetNetwork]
    ] = None,
    serverCertificateArn: Option[String] = None,
    authenticationOptions: Option[
      Iterable[zio.aws.ec2.model.ClientVpnAuthentication]
    ] = None,
    connectionLogOptions: Option[
      zio.aws.ec2.model.ConnectionLogResponseOptions
    ] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    securityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    vpcId: Option[VpcId] = None,
    selfServicePortalUrl: Option[String] = None,
    clientConnectOptions: Option[
      zio.aws.ec2.model.ClientConnectResponseOptions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClientVpnEndpoint = {
    import ClientVpnEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClientVpnEndpoint
      .builder()
      .optionallyWith(
        clientVpnEndpointId.map(value => value: java.lang.String)
      )(_.clientVpnEndpointId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(creationTime.map(value => value: java.lang.String))(
        _.creationTime
      )
      .optionallyWith(deletionTime.map(value => value: java.lang.String))(
        _.deletionTime
      )
      .optionallyWith(dnsName.map(value => value: java.lang.String))(_.dnsName)
      .optionallyWith(clientCidrBlock.map(value => value: java.lang.String))(
        _.clientCidrBlock
      )
      .optionallyWith(
        dnsServers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dnsServers)
      .optionallyWith(splitTunnel.map(value => value: java.lang.Boolean))(
        _.splitTunnel
      )
      .optionallyWith(vpnProtocol.map(value => value.unwrap))(_.vpnProtocol)
      .optionallyWith(transportProtocol.map(value => value.unwrap))(
        _.transportProtocol
      )
      .optionallyWith(
        vpnPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.vpnPort)
      .optionallyWith(
        associatedTargetNetworks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associatedTargetNetworks)
      .optionallyWith(
        serverCertificateArn.map(value => value: java.lang.String)
      )(_.serverCertificateArn)
      .optionallyWith(
        authenticationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.authenticationOptions)
      .optionallyWith(connectionLogOptions.map(value => value.buildAwsValue()))(
        _.connectionLogOptions
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        selfServicePortalUrl.map(value => value: java.lang.String)
      )(_.selfServicePortalUrl)
      .optionallyWith(clientConnectOptions.map(value => value.buildAwsValue()))(
        _.clientConnectOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClientVpnEndpoint.ReadOnly =
    zio.aws.ec2.model.ClientVpnEndpoint.wrap(buildAwsValue())
}
object ClientVpnEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClientVpnEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClientVpnEndpoint =
      zio.aws.ec2.model.ClientVpnEndpoint(
        clientVpnEndpointId.map(value => value),
        description.map(value => value),
        status.map(value => value.asEditable),
        creationTime.map(value => value),
        deletionTime.map(value => value),
        dnsName.map(value => value),
        clientCidrBlock.map(value => value),
        dnsServers.map(value => value),
        splitTunnel.map(value => value),
        vpnProtocol.map(value => value),
        transportProtocol.map(value => value),
        vpnPort.map(value => value),
        associatedTargetNetworks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serverCertificateArn.map(value => value),
        authenticationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        connectionLogOptions.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityGroupIds.map(value => value),
        vpcId.map(value => value),
        selfServicePortalUrl.map(value => value),
        clientConnectOptions.map(value => value.asEditable)
      )
    def clientVpnEndpointId: Option[String]
    def description: Option[String]
    def status: Option[zio.aws.ec2.model.ClientVpnEndpointStatus.ReadOnly]
    def creationTime: Option[String]
    def deletionTime: Option[String]
    def dnsName: Option[String]
    def clientCidrBlock: Option[String]
    def dnsServers: Option[List[String]]
    def splitTunnel: Option[Boolean]
    def vpnProtocol: Option[zio.aws.ec2.model.VpnProtocol]
    def transportProtocol: Option[zio.aws.ec2.model.TransportProtocol]
    def vpnPort: Option[Integer]
    def associatedTargetNetworks
        : Option[List[zio.aws.ec2.model.AssociatedTargetNetwork.ReadOnly]]
    def serverCertificateArn: Option[String]
    def authenticationOptions
        : Option[List[zio.aws.ec2.model.ClientVpnAuthentication.ReadOnly]]
    def connectionLogOptions
        : Option[zio.aws.ec2.model.ConnectionLogResponseOptions.ReadOnly]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def securityGroupIds: Option[List[SecurityGroupId]]
    def vpcId: Option[VpcId]
    def selfServicePortalUrl: Option[String]
    def clientConnectOptions
        : Option[zio.aws.ec2.model.ClientConnectResponseOptions.ReadOnly]
    def getClientVpnEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientVpnEndpointId", clientVpnEndpointId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientVpnEndpointStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDeletionTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deletionTime", deletionTime)
    def getDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getClientCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientCidrBlock", clientCidrBlock)
    def getDnsServers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dnsServers", dnsServers)
    def getSplitTunnel: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("splitTunnel", splitTunnel)
    def getVpnProtocol: ZIO[Any, AwsError, zio.aws.ec2.model.VpnProtocol] =
      AwsError.unwrapOptionField("vpnProtocol", vpnProtocol)
    def getTransportProtocol
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransportProtocol] =
      AwsError.unwrapOptionField("transportProtocol", transportProtocol)
    def getVpnPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("vpnPort", vpnPort)
    def getAssociatedTargetNetworks: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AssociatedTargetNetwork.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "associatedTargetNetworks",
      associatedTargetNetworks
    )
    def getServerCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverCertificateArn", serverCertificateArn)
    def getAuthenticationOptions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ClientVpnAuthentication.ReadOnly
    ]] =
      AwsError.unwrapOptionField("authenticationOptions", authenticationOptions)
    def getConnectionLogOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ConnectionLogResponseOptions.ReadOnly
    ] = AwsError.unwrapOptionField("connectionLogOptions", connectionLogOptions)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSelfServicePortalUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("selfServicePortalUrl", selfServicePortalUrl)
    def getClientConnectOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientConnectResponseOptions.ReadOnly
    ] = AwsError.unwrapOptionField("clientConnectOptions", clientConnectOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnEndpoint
  ) extends zio.aws.ec2.model.ClientVpnEndpoint.ReadOnly {
    override val clientVpnEndpointId: Option[String] =
      scala.Option(impl.clientVpnEndpointId()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val status
        : Option[zio.aws.ec2.model.ClientVpnEndpointStatus.ReadOnly] = scala
      .Option(impl.status())
      .map(value => zio.aws.ec2.model.ClientVpnEndpointStatus.wrap(value))
    override val creationTime: Option[String] =
      scala.Option(impl.creationTime()).map(value => value: String)
    override val deletionTime: Option[String] =
      scala.Option(impl.deletionTime()).map(value => value: String)
    override val dnsName: Option[String] =
      scala.Option(impl.dnsName()).map(value => value: String)
    override val clientCidrBlock: Option[String] =
      scala.Option(impl.clientCidrBlock()).map(value => value: String)
    override val dnsServers: Option[List[String]] = scala
      .Option(impl.dnsServers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val splitTunnel: Option[Boolean] =
      scala.Option(impl.splitTunnel()).map(value => value: Boolean)
    override val vpnProtocol: Option[zio.aws.ec2.model.VpnProtocol] = scala
      .Option(impl.vpnProtocol())
      .map(value => zio.aws.ec2.model.VpnProtocol.wrap(value))
    override val transportProtocol
        : Option[zio.aws.ec2.model.TransportProtocol] = scala
      .Option(impl.transportProtocol())
      .map(value => zio.aws.ec2.model.TransportProtocol.wrap(value))
    override val vpnPort: Option[Integer] = scala
      .Option(impl.vpnPort())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val associatedTargetNetworks
        : Option[List[zio.aws.ec2.model.AssociatedTargetNetwork.ReadOnly]] =
      scala
        .Option(impl.associatedTargetNetworks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AssociatedTargetNetwork.wrap(item)
          }.toList
        )
    override val serverCertificateArn: Option[String] =
      scala.Option(impl.serverCertificateArn()).map(value => value: String)
    override val authenticationOptions
        : Option[List[zio.aws.ec2.model.ClientVpnAuthentication.ReadOnly]] =
      scala
        .Option(impl.authenticationOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ClientVpnAuthentication.wrap(item)
          }.toList
        )
    override val connectionLogOptions
        : Option[zio.aws.ec2.model.ConnectionLogResponseOptions.ReadOnly] =
      scala
        .Option(impl.connectionLogOptions())
        .map(value =>
          zio.aws.ec2.model.ConnectionLogResponseOptions.wrap(value)
        )
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val securityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.ec2.model.primitives.VpcId(value))
    override val selfServicePortalUrl: Option[String] =
      scala.Option(impl.selfServicePortalUrl()).map(value => value: String)
    override val clientConnectOptions
        : Option[zio.aws.ec2.model.ClientConnectResponseOptions.ReadOnly] =
      scala
        .Option(impl.clientConnectOptions())
        .map(value =>
          zio.aws.ec2.model.ClientConnectResponseOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnEndpoint
  ): zio.aws.ec2.model.ClientVpnEndpoint.ReadOnly = new Wrapper(impl)
}
