package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait CapacityReservationTenancy {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.CapacityReservationTenancy
}
object CapacityReservationTenancy {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.CapacityReservationTenancy
  ): zio.aws.ec2.model.CapacityReservationTenancy = value match {
    case software.amazon.awssdk.services.ec2.model.CapacityReservationTenancy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationTenancy.DEFAULT =>
      val r = default
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationTenancy.DEDICATED =>
      val r = dedicated
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.CapacityReservationTenancy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationTenancy =
      software.amazon.awssdk.services.ec2.model.CapacityReservationTenancy.UNKNOWN_TO_SDK_VERSION
  }
  case object default extends zio.aws.ec2.model.CapacityReservationTenancy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationTenancy =
      software.amazon.awssdk.services.ec2.model.CapacityReservationTenancy.DEFAULT
  }
  case object dedicated extends zio.aws.ec2.model.CapacityReservationTenancy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationTenancy =
      software.amazon.awssdk.services.ec2.model.CapacityReservationTenancy.DEDICATED
  }
}
