package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CapacityReservationGroup(
    groupArn: Option[String] = None,
    ownerId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CapacityReservationGroup = {
    import CapacityReservationGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CapacityReservationGroup
      .builder()
      .optionallyWith(groupArn.map(value => value: java.lang.String))(
        _.groupArn
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CapacityReservationGroup.ReadOnly =
    zio.aws.ec2.model.CapacityReservationGroup.wrap(buildAwsValue())
}
object CapacityReservationGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CapacityReservationGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CapacityReservationGroup =
      zio.aws.ec2.model.CapacityReservationGroup(
        groupArn.map(value => value),
        ownerId.map(value => value)
      )
    def groupArn: Option[String]
    def ownerId: Option[String]
    def getGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupArn", groupArn)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservationGroup
  ) extends zio.aws.ec2.model.CapacityReservationGroup.ReadOnly {
    override val groupArn: Option[String] =
      scala.Option(impl.groupArn()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservationGroup
  ): zio.aws.ec2.model.CapacityReservationGroup.ReadOnly = new Wrapper(impl)
}
