package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  OutpostArn,
  DateTime,
  MillisecondDateTime,
  Integer
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CapacityReservation(
    capacityReservationId: Option[String] = None,
    ownerId: Option[String] = None,
    capacityReservationArn: Option[String] = None,
    availabilityZoneId: Option[String] = None,
    instanceType: Option[String] = None,
    instancePlatform: Option[
      zio.aws.ec2.model.CapacityReservationInstancePlatform
    ] = None,
    availabilityZone: Option[String] = None,
    tenancy: Option[zio.aws.ec2.model.CapacityReservationTenancy] = None,
    totalInstanceCount: Option[Integer] = None,
    availableInstanceCount: Option[Integer] = None,
    ebsOptimized: Option[Boolean] = None,
    ephemeralStorage: Option[Boolean] = None,
    state: Option[zio.aws.ec2.model.CapacityReservationState] = None,
    startDate: Option[MillisecondDateTime] = None,
    endDate: Option[DateTime] = None,
    endDateType: Option[zio.aws.ec2.model.EndDateType] = None,
    instanceMatchCriteria: Option[zio.aws.ec2.model.InstanceMatchCriteria] =
      None,
    createDate: Option[DateTime] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    outpostArn: Option[OutpostArn] = None,
    capacityReservationFleetId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CapacityReservation = {
    import CapacityReservation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CapacityReservation
      .builder()
      .optionallyWith(
        capacityReservationId.map(value => value: java.lang.String)
      )(_.capacityReservationId)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        capacityReservationArn.map(value => value: java.lang.String)
      )(_.capacityReservationArn)
      .optionallyWith(availabilityZoneId.map(value => value: java.lang.String))(
        _.availabilityZoneId
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(instancePlatform.map(value => value.unwrap))(
        _.instancePlatform
      )
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .optionallyWith(
        totalInstanceCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.totalInstanceCount)
      .optionallyWith(
        availableInstanceCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.availableInstanceCount)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(ephemeralStorage.map(value => value: java.lang.Boolean))(
        _.ephemeralStorage
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        startDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.startDate)
      .optionallyWith(endDate.map(value => DateTime.unwrap(value): Instant))(
        _.endDate
      )
      .optionallyWith(endDateType.map(value => value.unwrap))(_.endDateType)
      .optionallyWith(instanceMatchCriteria.map(value => value.unwrap))(
        _.instanceMatchCriteria
      )
      .optionallyWith(createDate.map(value => DateTime.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        outpostArn.map(value => OutpostArn.unwrap(value): java.lang.String)
      )(_.outpostArn)
      .optionallyWith(
        capacityReservationFleetId.map(value => value: java.lang.String)
      )(_.capacityReservationFleetId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CapacityReservation.ReadOnly =
    zio.aws.ec2.model.CapacityReservation.wrap(buildAwsValue())
}
object CapacityReservation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CapacityReservation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CapacityReservation =
      zio.aws.ec2.model.CapacityReservation(
        capacityReservationId.map(value => value),
        ownerId.map(value => value),
        capacityReservationArn.map(value => value),
        availabilityZoneId.map(value => value),
        instanceType.map(value => value),
        instancePlatform.map(value => value),
        availabilityZone.map(value => value),
        tenancy.map(value => value),
        totalInstanceCount.map(value => value),
        availableInstanceCount.map(value => value),
        ebsOptimized.map(value => value),
        ephemeralStorage.map(value => value),
        state.map(value => value),
        startDate.map(value => value),
        endDate.map(value => value),
        endDateType.map(value => value),
        instanceMatchCriteria.map(value => value),
        createDate.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outpostArn.map(value => value),
        capacityReservationFleetId.map(value => value)
      )
    def capacityReservationId: Option[String]
    def ownerId: Option[String]
    def capacityReservationArn: Option[String]
    def availabilityZoneId: Option[String]
    def instanceType: Option[String]
    def instancePlatform
        : Option[zio.aws.ec2.model.CapacityReservationInstancePlatform]
    def availabilityZone: Option[String]
    def tenancy: Option[zio.aws.ec2.model.CapacityReservationTenancy]
    def totalInstanceCount: Option[Integer]
    def availableInstanceCount: Option[Integer]
    def ebsOptimized: Option[Boolean]
    def ephemeralStorage: Option[Boolean]
    def state: Option[zio.aws.ec2.model.CapacityReservationState]
    def startDate: Option[MillisecondDateTime]
    def endDate: Option[DateTime]
    def endDateType: Option[zio.aws.ec2.model.EndDateType]
    def instanceMatchCriteria: Option[zio.aws.ec2.model.InstanceMatchCriteria]
    def createDate: Option[DateTime]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def outpostArn: Option[OutpostArn]
    def capacityReservationFleetId: Option[String]
    def getCapacityReservationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("capacityReservationId", capacityReservationId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getCapacityReservationArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("capacityReservationArn", capacityReservationArn)
    def getAvailabilityZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstancePlatform: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CapacityReservationInstancePlatform
    ] = AwsError.unwrapOptionField("instancePlatform", instancePlatform)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getTenancy
        : ZIO[Any, AwsError, zio.aws.ec2.model.CapacityReservationTenancy] =
      AwsError.unwrapOptionField("tenancy", tenancy)
    def getTotalInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalInstanceCount", totalInstanceCount)
    def getAvailableInstanceCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("availableInstanceCount", availableInstanceCount)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getEphemeralStorage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ephemeralStorage", ephemeralStorage)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.CapacityReservationState] =
      AwsError.unwrapOptionField("state", state)
    def getStartDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getEndDateType: ZIO[Any, AwsError, zio.aws.ec2.model.EndDateType] =
      AwsError.unwrapOptionField("endDateType", endDateType)
    def getInstanceMatchCriteria
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceMatchCriteria] =
      AwsError.unwrapOptionField("instanceMatchCriteria", instanceMatchCriteria)
    def getCreateDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getOutpostArn: ZIO[Any, AwsError, OutpostArn] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getCapacityReservationFleetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "capacityReservationFleetId",
        capacityReservationFleetId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservation
  ) extends zio.aws.ec2.model.CapacityReservation.ReadOnly {
    override val capacityReservationId: Option[String] =
      scala.Option(impl.capacityReservationId()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val capacityReservationArn: Option[String] =
      scala.Option(impl.capacityReservationArn()).map(value => value: String)
    override val availabilityZoneId: Option[String] =
      scala.Option(impl.availabilityZoneId()).map(value => value: String)
    override val instanceType: Option[String] =
      scala.Option(impl.instanceType()).map(value => value: String)
    override val instancePlatform
        : Option[zio.aws.ec2.model.CapacityReservationInstancePlatform] = scala
      .Option(impl.instancePlatform())
      .map(value =>
        zio.aws.ec2.model.CapacityReservationInstancePlatform.wrap(value)
      )
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val tenancy: Option[zio.aws.ec2.model.CapacityReservationTenancy] =
      scala
        .Option(impl.tenancy())
        .map(value => zio.aws.ec2.model.CapacityReservationTenancy.wrap(value))
    override val totalInstanceCount: Option[Integer] = scala
      .Option(impl.totalInstanceCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val availableInstanceCount: Option[Integer] = scala
      .Option(impl.availableInstanceCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val ebsOptimized: Option[Boolean] =
      scala.Option(impl.ebsOptimized()).map(value => value: Boolean)
    override val ephemeralStorage: Option[Boolean] =
      scala.Option(impl.ephemeralStorage()).map(value => value: Boolean)
    override val state: Option[zio.aws.ec2.model.CapacityReservationState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.ec2.model.CapacityReservationState.wrap(value))
    override val startDate: Option[MillisecondDateTime] = scala
      .Option(impl.startDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val endDate: Option[DateTime] = scala
      .Option(impl.endDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val endDateType: Option[zio.aws.ec2.model.EndDateType] = scala
      .Option(impl.endDateType())
      .map(value => zio.aws.ec2.model.EndDateType.wrap(value))
    override val instanceMatchCriteria
        : Option[zio.aws.ec2.model.InstanceMatchCriteria] = scala
      .Option(impl.instanceMatchCriteria())
      .map(value => zio.aws.ec2.model.InstanceMatchCriteria.wrap(value))
    override val createDate: Option[DateTime] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val outpostArn: Option[OutpostArn] = scala
      .Option(impl.outpostArn())
      .map(value => zio.aws.ec2.model.primitives.OutpostArn(value))
    override val capacityReservationFleetId: Option[String] = scala
      .Option(impl.capacityReservationFleetId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservation
  ): zio.aws.ec2.model.CapacityReservation.ReadOnly = new Wrapper(impl)
}
