package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AssociatedNetworkType {
  def unwrap: software.amazon.awssdk.services.ec2.model.AssociatedNetworkType
}
object AssociatedNetworkType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AssociatedNetworkType
  ): zio.aws.ec2.model.AssociatedNetworkType = value match {
    case software.amazon.awssdk.services.ec2.model.AssociatedNetworkType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AssociatedNetworkType.VPC =>
      val r = vpc
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.AssociatedNetworkType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AssociatedNetworkType =
      software.amazon.awssdk.services.ec2.model.AssociatedNetworkType.UNKNOWN_TO_SDK_VERSION
  }
  case object vpc extends zio.aws.ec2.model.AssociatedNetworkType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AssociatedNetworkType =
      software.amazon.awssdk.services.ec2.model.AssociatedNetworkType.VPC
  }
}
