package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateIamInstanceProfileRequest(
    iamInstanceProfile: zio.aws.ec2.model.IamInstanceProfileSpecification,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileRequest = {
    import AssociateIamInstanceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileRequest
      .builder()
      .iamInstanceProfile(iamInstanceProfile.buildAwsValue())
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssociateIamInstanceProfileRequest.ReadOnly =
    zio.aws.ec2.model.AssociateIamInstanceProfileRequest.wrap(buildAwsValue())
}
object AssociateIamInstanceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateIamInstanceProfileRequest =
      zio.aws.ec2.model.AssociateIamInstanceProfileRequest(
        iamInstanceProfile.asEditable,
        instanceId
      )
    def iamInstanceProfile
        : zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly
    def instanceId: InstanceId
    def getIamInstanceProfile: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly
    ] = ZIO.succeed(iamInstanceProfile)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileRequest
  ) extends zio.aws.ec2.model.AssociateIamInstanceProfileRequest.ReadOnly {
    override val iamInstanceProfile
        : zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly =
      zio.aws.ec2.model.IamInstanceProfileSpecification
        .wrap(impl.iamInstanceProfile())
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileRequest
  ): zio.aws.ec2.model.AssociateIamInstanceProfileRequest.ReadOnly =
    new Wrapper(impl)
}
